/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.providers;

import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ProgressTreeNode
implements IProgressMonitor,
Listener {
    private static Image emptyProgress;
    private static Image fullProgress;
    protected boolean done = false;
    private int tWork = 100;
    private double worked = 0.0;
    private String taskName = "Pending...";
    private boolean canceled = false;
    private TreeViewer viewer;
    private ProgressNodeUpdater updater = new ProgressNodeUpdater(this);

    static {
        URL emptyURL = Activator.getDefault().getBundle().getEntry("icons/extras/progress_bar_empty.gif");
        emptyProgress = ImageDescriptor.createFromURL((URL)emptyURL).createImage();
        URL fullURL = Activator.getDefault().getBundle().getEntry("icons/extras/progress_bar_full.gif");
        fullProgress = ImageDescriptor.createFromURL((URL)fullURL).createImage();
    }

    public ProgressTreeNode(TreeViewer viewer) {
        this.viewer = viewer;
        final Tree tree = viewer.getTree();
        if (!tree.isDisposed()) {
            Display display = tree.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    if (!tree.isDisposed()) {
                        tree.addListener(41, (Listener)ProgressTreeNode.this);
                        tree.addListener(40, (Listener)ProgressTreeNode.this);
                        tree.addListener(42, (Listener)ProgressTreeNode.this);
                    }
                }
            });
        }
    }

    public void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.tWork = totalWork;
        this.worked = 0.0;
        this.done = false;
        this.canceled = false;
        this.update();
    }

    public void done() {
        this.worked = this.tWork;
        this.done = true;
        this.update();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void handleEvent(Event event) {
        Object data;
        if (event.item instanceof TreeItem && event.index == 0 && (data = ((TreeItem)event.item).getData()) == this) {
            switch (event.type) {
                case 41: {
                    this.measureItem(event);
                    break;
                }
                case 40: {
                    this.eraseItem(event);
                    break;
                }
                case 42: {
                    this.paintItem(event);
                }
            }
        }
    }

    public void internalWorked(double work) {
        this.worked += work;
        this.update();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setCanceled(boolean value) {
        this.canceled = value;
        this.update();
    }

    public void setTaskName(String name) {
        this.taskName = name;
        this.update();
    }

    public String toString() {
        String resultString = String.valueOf(this.taskName) + " (" + String.valueOf(this.getProgressPercent()) + ")";
        return resultString;
    }

    public void subTask(String name) {
        this.setTaskName(name);
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private int getProgressPercent() {
        return (int)Math.round(100.0 * this.worked / (double)this.tWork);
    }

    void eraseItem(Event event) {
    }

    private void measureItem(Event event) {
        int textHeight = event.gc.getFontMetrics().getHeight();
        int imageWidth = ProgressTreeNode.emptyProgress.getBounds().width;
        int imageHeight = ProgressTreeNode.emptyProgress.getBounds().height;
        int textWidth = this.taskName == null ? 0 : event.gc.textExtent((String)this.taskName).x;
        event.height = Math.max(textHeight, imageHeight);
        event.width = textWidth + imageWidth + 2;
    }

    protected void paintItem(Event event) {
        Display display = this.viewer.getTree().getDisplay();
        Color black = display.getSystemColor(2);
        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
        Color white = display.getSystemColor(1);
        int progress = this.getProgressPercent();
        int barwidth = ProgressTreeNode.fullProgress.getBounds().width;
        int barheight = ProgressTreeNode.fullProgress.getBounds().height;
        int bary = event.y + (event.height - barheight) / 2;
        int barp = barwidth * progress / 100;
        event.gc.drawImage(emptyProgress, barp, 0, barwidth - barp, barheight, event.x + barp + 2, bary, barwidth - barp, barheight);
        event.gc.drawImage(fullProgress, 0, 0, barp, barheight, event.x + 2, bary, barp, barheight);
        String progressString = String.valueOf(String.valueOf(progress)) + "%";
        Point textExtend = event.gc.textExtent(progressString);
        int progressX = event.x + 2 + (barwidth - textExtend.x) / 2;
        event.gc.setForeground(white);
        event.gc.drawText(progressString, progressX + 1, event.y + 2, true);
        event.gc.setForeground(black);
        event.gc.drawText(progressString, progressX, event.y + 1, true);
        int textX = event.x + 6 + barwidth;
        if (this.taskName != null) {
            event.gc.setForeground(black);
            event.gc.drawText(this.taskName, textX, event.y + 1, true);
        }
    }

    protected void update() {
        Tree tree = this.getViewer().getTree();
        if (!tree.isDisposed()) {
            Display display = tree.getDisplay();
            display.asyncExec((Runnable)this.updater);
        }
    }

    private static class ProgressNodeUpdater
    implements Runnable {
        private ProgressTreeNode node;
        private String lastProgress;
        private boolean wasAlreadyDone;

        public ProgressNodeUpdater(ProgressTreeNode node) {
            this.node = node;
            this.wasAlreadyDone = false;
        }

        public void run() {
            String progress = this.node.toString();
            if (progress != null && !progress.equals(this.lastProgress)) {
                this.lastProgress = progress;
                this.node.getViewer().update((Object)this.node, null);
            } else if (this.node.isDone() && !this.wasAlreadyDone) {
                this.wasAlreadyDone = true;
                this.node.getViewer().getTree().redraw();
            }
        }

        public void reset() {
            this.lastProgress = null;
        }
    }
}

