/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.simpleTest;

import eu.geclipse.core.model.IGridResource;
import eu.geclipse.ui.dialogs.AbstractSimpleTestDialog;
import eu.geclipse.ui.simpleTest.DNSLookUpJob;
import eu.geclipse.ui.simpleTest.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSLookUpDialog
extends AbstractSimpleTestDialog {
    protected Table tableOutPut = null;
    protected String[][] itemStrings;
    protected DNSLookUpJob lookUpJob;
    private ArrayList<String> hostNames = new ArrayList();

    public DNSLookUpDialog(List<IGridResource> resources, Shell parentShell) {
        super(null, resources, parentShell);
        int i = 0;
        while (i < this.resources.size()) {
            String name = ((IGridResource)this.resources.get(i)).getHostName();
            if (name != null) {
                this.hostNames.add(name);
            }
            ++i;
        }
        this.itemStrings = new String[this.hostNames.size()][2];
        i = 0;
        while (i < this.hostNames.size()) {
            this.itemStrings[i][0] = this.hostNames.get(i);
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("DNSLookUpDialog.dialogTitle"));
    }

    public boolean close() {
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        mainComp.setLayoutData((Object)gData);
        Group outPutGroup = new Group(mainComp, 0);
        outPutGroup.setLayout((Layout)new GridLayout(2, false));
        outPutGroup.setText(Messages.getString("DNSLookUpDialog.output_group"));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.verticalAlignment = 1;
        outPutGroup.setLayoutData((Object)gData);
        Composite tableComp = new Composite((Composite)outPutGroup, 0);
        this.tableOutPut = new Table(tableComp, 268437506);
        this.tableOutPut.setHeaderVisible(true);
        this.tableOutPut.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true);
        this.tableOutPut.setLayoutData((Object)gd);
        GridData gridData = new GridData(1, 1, true, true);
        gridData.heightHint = 200;
        tableComp.setLayout((Layout)new GridLayout(2, false));
        tableComp.setLayoutData((Object)gData);
        TableColumn hostColumn = new TableColumn(this.tableOutPut, 16384);
        hostColumn.setText(Messages.getString("DNSLookUpDialog.hostName"));
        hostColumn.setWidth(250);
        TableColumn ipAdrColumn = new TableColumn(this.tableOutPut, 16384);
        ipAdrColumn.setText(Messages.getString("DNSLookUpDialog.ipAddress"));
        ipAdrColumn.setWidth(150);
        this.tableOutPut.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = DNSLookUpDialog.this.tableOutPut.indexOf(item);
                item.setText(DNSLookUpDialog.this.itemStrings[index]);
            }
        });
        this.tableOutPut.setItemCount(this.hostNames.size());
        this.lookUpJob = new DNSLookUpJob(this.tableOutPut, this.itemStrings);
        if (this.lookUpJob.getState() == 0) {
            this.lookUpJob.schedule();
        }
        return mainComp;
    }
}

