/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.simpleTest;

import eu.geclipse.ui.simpleTest.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class DNSLookUpJob
extends Job {
    protected Display display;
    protected Table table;
    private String[][] itemStrings;

    public DNSLookUpJob(Table table, String[][] itemString) {
        super(Messages.getString("DNSLookUpJob.lookUpMsg"));
        this.table = table;
        this.itemStrings = itemString;
        this.display = this.table.getDisplay();
    }

    protected IStatus run(IProgressMonitor monitor) {
        InetAddress adr = null;
        IStatus result = Status.CANCEL_STATUS;
        monitor.beginTask(String.valueOf(Messages.getString("DNSLookUpJob.lookUp")) + this.itemStrings.length + Messages.getString("DNSLookUpJob.hosts"), this.itemStrings.length);
        int i = 0;
        while (i < this.itemStrings.length && !monitor.isCanceled()) {
            try {
                adr = InetAddress.getByName(this.itemStrings[i][0]);
                this.itemStrings[i][1] = adr != null ? adr.getHostAddress() : Messages.getString("DNSLookUpJob.n_a");
            }
            catch (UnknownHostException unknownHostException) {
                this.itemStrings[i][1] = Messages.getString("DNSLookUpJob.n_a");
            }
            if (!this.display.isDisposed()) {
                this.display.syncExec(new Runnable(){

                    public void run() {
                        if (!DNSLookUpJob.this.table.isDisposed()) {
                            DNSLookUpJob.this.table.clearAll();
                        }
                    }
                });
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
        result = Status.OK_STATUS;
        return result;
    }
}

