/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.simpleTest;

import eu.geclipse.core.simpleTest.ReachabilityTest;
import eu.geclipse.ui.simpleTest.Messages;
import java.net.InetAddress;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ReachabilityHostJob
extends Job {
    private static DecimalFormat df = new DecimalFormat("0.000");
    protected String lineDelimiter;
    protected ReachabilityTest pingTest;
    protected Display display;
    protected String summary;
    protected double pingDelay;
    private InetAddress hostAdr;
    private int numPing;
    private Text outPut;
    private Table table;
    private String hostName;
    private String[] itemString;
    private int index;
    private long timeOut;

    public ReachabilityHostJob(InetAddress hostAdr, int nPing, long timeOut, Text outPut, Table table, String[] itemString, int index, ReachabilityTest pingTest) {
        super(String.valueOf(Messages.getString("ReachabilityHostJob.pingMsg")) + hostAdr.getHostName());
        this.hostName = hostAdr.getHostName();
        this.hostAdr = hostAdr;
        this.numPing = nPing;
        this.outPut = outPut;
        this.pingTest = pingTest;
        this.timeOut = timeOut;
        this.display = this.outPut.getDisplay();
        this.lineDelimiter = this.outPut.getLineDelimiter();
        this.table = table;
        this.itemString = itemString;
        this.index = index;
    }

    protected IStatus run(IProgressMonitor monitor) {
        double min = 9.223372036854776E18;
        double max = -9.223372036854776E18;
        double avg = 0.0;
        int nOk = 0;
        int nFailed = 0;
        IStatus result = Status.CANCEL_STATUS;
        monitor.beginTask(String.valueOf(Messages.getString("ReachabilityTestDialog.pingMsg")) + this.hostName + " " + this.numPing + Messages.getString("ReachabilityTestDialog.spacePlusTimes"), this.numPing);
        int i = 0;
        while (i < this.numPing && !monitor.isCanceled()) {
            this.pingDelay = this.pingTest.ping(this.hostAdr);
            if (-1.0 == this.pingDelay) {
                ++nFailed;
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            if (!ReachabilityHostJob.this.outPut.isDisposed()) {
                                ReachabilityHostJob.this.outPut.append(String.valueOf(ReachabilityHostJob.this.hostName) + ": " + Messages.getString("ReachabilityTestDialog.notReachable") + ReachabilityHostJob.this.lineDelimiter);
                            }
                        }
                    });
                }
            } else {
                ++nOk;
                if (this.pingDelay < min) {
                    min = this.pingDelay;
                }
                if (this.pingDelay > max) {
                    max = this.pingDelay;
                }
                avg += this.pingDelay;
                if (!this.display.isDisposed()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            if (!ReachabilityHostJob.this.outPut.isDisposed()) {
                                ReachabilityHostJob.this.outPut.append(String.valueOf(ReachabilityHostJob.this.hostName) + ": " + Messages.getString("ReachabilityTestDialog.time") + df.format(ReachabilityHostJob.this.pingDelay) + " ms" + ReachabilityHostJob.this.lineDelimiter);
                            }
                        }
                    });
                }
            }
            this.itemString[1] = Integer.toString(i + 1);
            if (!this.display.isDisposed()) {
                this.display.syncExec(new Runnable(){

                    public void run() {
                        if (!ReachabilityHostJob.this.table.isDisposed()) {
                            ReachabilityHostJob.this.table.clear(ReachabilityHostJob.this.index);
                        }
                    }
                });
            }
            if (i < this.numPing - 1) {
                try {
                    Thread.sleep(this.timeOut * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            monitor.worked(1);
            ++i;
        }
        this.summary = String.valueOf(this.lineDelimiter) + "Summary for: " + this.hostName + this.lineDelimiter + i + Messages.getString("ReachabilityTestDialog.transmitted") + nOk + Messages.getString("ReachabilityTestDialog.receivedPlusSpace") + df.format((double)nFailed / (double)i * 100.0) + Messages.getString("ReachabilityTestDialog.packetLoss") + this.lineDelimiter;
        if (nOk > 0) {
            this.summary = this.summary.concat(String.valueOf(Messages.getString("ReachabilityTestDialog.summaryPlusSpace")) + df.format(min) + "/" + df.format(avg / (double)nOk) + "/" + df.format(max) + " ms" + this.lineDelimiter + this.lineDelimiter);
            this.itemString[1] = Integer.toString(i);
            this.itemString[2] = Integer.toString(nOk);
            this.itemString[3] = df.format(min);
            this.itemString[4] = df.format(avg / (double)nOk);
            this.itemString[5] = df.format(max);
        } else {
            this.summary = this.summary.concat(String.valueOf(Messages.getString("ReachabilityTestDialog.summaryFailed")) + this.lineDelimiter + this.lineDelimiter);
            this.itemString[1] = Integer.toString(i);
            this.itemString[2] = Integer.toString(0);
            this.itemString[3] = Messages.getString("ReachabilityTestDialog.n_a");
            this.itemString[4] = Messages.getString("ReachabilityTestDialog.n_a");
            this.itemString[5] = Messages.getString("ReachabilityTestDialog.n_a");
        }
        if (!this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (!ReachabilityHostJob.this.outPut.isDisposed()) {
                        ReachabilityHostJob.this.outPut.append(ReachabilityHostJob.this.summary);
                        ReachabilityHostJob.this.table.clear(ReachabilityHostJob.this.index);
                    }
                }
            });
        }
        monitor.done();
        result = Status.OK_STATUS;
        return result;
    }
}

