/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.simpleTest;

import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.simpleTest.ISimpleTest;
import eu.geclipse.core.simpleTest.ReachabilityTest;
import eu.geclipse.ui.dialogs.AbstractSimpleTestDialog;
import eu.geclipse.ui.simpleTest.Messages;
import eu.geclipse.ui.simpleTest.ReachabilityHostJob;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReachabilityTestDialog
extends AbstractSimpleTestDialog {
    protected ArrayList<ReachabilityHostJob> pingJobs = new ArrayList();
    protected Table tableOutPut = null;
    protected String[][] itemStrings;
    private Text outPut = null;
    private Spinner numberSpn = null;
    private Spinner delaySpn = null;
    private ArrayList<InetAddress> hostAdrs = new ArrayList();
    private ArrayList<String> hostNames = new ArrayList();

    public ReachabilityTestDialog(ISimpleTest test, List<IGridResource> resources, Shell parentShell) {
        super(test, resources, parentShell);
        int i = 0;
        while (i < this.resources.size()) {
            String name = ((IGridResource)this.resources.get(i)).getHostName();
            if (name != null) {
                this.hostNames.add(name);
            }
            ++i;
        }
        this.itemStrings = new String[this.hostNames.size()][6];
        i = 0;
        while (i < this.hostNames.size()) {
            this.itemStrings[i][0] = this.hostNames.get(i);
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(600, 400);
        newShell.setText(Messages.getString("ReachabilityTestDialog.dialogTitle"));
    }

    public boolean close() {
        for (ReachabilityHostJob job : this.pingJobs) {
            job.cancel();
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        mainComp.setLayoutData((Object)gData);
        Group settingsGroup = new Group(mainComp, 0);
        settingsGroup.setLayout((Layout)new GridLayout(3, false));
        settingsGroup.setText(Messages.getString("ReachabilityTestDialog.settings_group"));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        settingsGroup.setLayoutData((Object)gData);
        Label numPingsLabel = new Label((Composite)settingsGroup, 16384);
        numPingsLabel.setText(Messages.getString("ReachabilityTestDialog.nPingsLabel"));
        gData = new GridData();
        numPingsLabel.setLayoutData((Object)gData);
        this.numberSpn = new Spinner((Composite)settingsGroup, 18436);
        this.numberSpn.setValues(2, 1, 100, 0, 1, 2);
        gData = new GridData(768);
        gData.horizontalSpan = 2;
        gData.grabExcessHorizontalSpace = true;
        this.numberSpn.setLayoutData((Object)gData);
        Label delayLabel = new Label((Composite)settingsGroup, 16384);
        delayLabel.setText(Messages.getString("ReachabilityTestDialog.delayLabel"));
        gData = new GridData();
        delayLabel.setLayoutData((Object)gData);
        this.delaySpn = new Spinner((Composite)settingsGroup, 18436);
        this.delaySpn.setValues(1, 1, 10, 0, 1, 10);
        gData = new GridData(768);
        gData.horizontalSpan = 2;
        gData.grabExcessHorizontalSpace = true;
        this.delaySpn.setLayoutData((Object)gData);
        Group outPutGroup = new Group(mainComp, 0);
        outPutGroup.setLayout((Layout)new GridLayout(3, false));
        outPutGroup.setText(Messages.getString("ReachabilityTestDialog.output_group"));
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        outPutGroup.setLayoutData((Object)gData);
        TabFolder tabFolder = new TabFolder((Composite)outPutGroup, 0);
        TabItem itemTblOutPut = new TabItem(tabFolder, 0);
        itemTblOutPut.setText(Messages.getString("ReachabilityTestDialog.results"));
        this.tableOutPut = new Table((Composite)tabFolder, 268437506);
        this.tableOutPut.setHeaderVisible(true);
        this.tableOutPut.setLinesVisible(true);
        TableColumn hostColumn = new TableColumn(this.tableOutPut, 0);
        hostColumn.setText(Messages.getString("ReachabilityTestDialog.hostName"));
        hostColumn.setWidth(150);
        hostColumn.setAlignment(16384);
        TableColumn sndColumn = new TableColumn(this.tableOutPut, 0x1000000);
        sndColumn.setText(Messages.getString("ReachabilityTestDialog.snd"));
        sndColumn.setWidth(75);
        sndColumn.setAlignment(0x1000000);
        TableColumn recColumn = new TableColumn(this.tableOutPut, 0x1000000);
        recColumn.setText(Messages.getString("ReachabilityTestDialog.rec"));
        recColumn.setWidth(75);
        recColumn.setAlignment(0x1000000);
        TableColumn minColumn = new TableColumn(this.tableOutPut, 0x1000000);
        minColumn.setText(Messages.getString("ReachabilityTestDialog.min"));
        minColumn.setWidth(75);
        minColumn.setAlignment(0x1000000);
        TableColumn avgColumn = new TableColumn(this.tableOutPut, 0x1000000);
        avgColumn.setText(Messages.getString("ReachabilityTestDialog.avg"));
        avgColumn.setWidth(75);
        avgColumn.setAlignment(0x1000000);
        TableColumn maxColumn = new TableColumn(this.tableOutPut, 0x1000000);
        maxColumn.setText(Messages.getString("ReachabilityTestDialog.max"));
        maxColumn.setWidth(75);
        maxColumn.setAlignment(0x1000000);
        itemTblOutPut.setControl((Control)this.tableOutPut);
        this.tableOutPut.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int index = ReachabilityTestDialog.this.tableOutPut.indexOf(item);
                item.setText(ReachabilityTestDialog.this.itemStrings[index]);
            }
        });
        this.tableOutPut.setItemCount(this.hostNames.size());
        TabItem itemRawOutPut = new TabItem(tabFolder, 0);
        itemRawOutPut.setText(Messages.getString("ReachabilityTestDialog.logging"));
        this.outPut = new Text((Composite)tabFolder, 2818);
        this.outPut.setEditable(false);
        itemRawOutPut.setControl((Control)this.outPut);
        gData = new GridData(4, 4, true, true);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        tabFolder.setLayoutData((Object)gData);
        Composite outControls = new Composite((Composite)outPutGroup, 0);
        GridLayout gLayout = new GridLayout(1, false);
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        outControls.setLayout((Layout)gLayout);
        gData = new GridData(2);
        outControls.setLayoutData((Object)gData);
        Button pingButton = new Button(outControls, 8);
        pingButton.setText(Messages.getString("ReachabilityTestDialog.pingButton"));
        pingButton.setToolTipText(Messages.getString("ReachabilityTestDialog.pingButtonToolTip"));
        gData = new GridData(768);
        gData.verticalAlignment = 1;
        pingButton.setLayoutData((Object)gData);
        Button stopButton = new Button(outControls, 8);
        stopButton.setText(Messages.getString("ReachabilityTestDialog.stopButton"));
        stopButton.setToolTipText(Messages.getString("ReachabilityTestDialog.stopButtonToolTip"));
        gData = new GridData(768);
        gData.verticalAlignment = 1;
        stopButton.setLayoutData((Object)gData);
        Button clearButton = new Button(outControls, 8);
        clearButton.setText(Messages.getString("ReachabilityTestDialog.clearButton"));
        clearButton.setToolTipText(Messages.getString("ReachabilityTestDialog.clearButtonToolTip"));
        gData = new GridData(768);
        gData.verticalAlignment = 1;
        clearButton.setLayoutData((Object)gData);
        pingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean done = true;
                for (ReachabilityHostJob job : ReachabilityTestDialog.this.pingJobs) {
                    if (job.getResult() != null) continue;
                    done = false;
                }
                if (done) {
                    ReachabilityTestDialog.this.runPing();
                }
            }
        });
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ReachabilityHostJob job : ReachabilityTestDialog.this.pingJobs) {
                    job.cancel();
                }
                ReachabilityTestDialog.this.pingJobs.clear();
            }
        });
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean done = true;
                for (ReachabilityHostJob job : ReachabilityTestDialog.this.pingJobs) {
                    if (job.getResult() != null) continue;
                    done = false;
                }
                if (done) {
                    ReachabilityTestDialog.this.clearLogs();
                }
            }
        });
        return mainComp;
    }

    protected void runPing() {
        InetAddress adr = null;
        int number = this.numberSpn.getSelection();
        int delay = this.delaySpn.getSelection();
        if (this.resources != null) {
            this.hostAdrs.clear();
            this.pingJobs.clear();
            this.clearItemString();
            this.outPut.append(String.valueOf(Messages.getString("ReachabilityTestDialog.pingHostsPlusSpace")) + this.outPut.getLineDelimiter());
            for (String host : this.hostNames) {
                try {
                    adr = InetAddress.getByName(host);
                    this.hostAdrs.add(adr);
                    this.outPut.append(String.valueOf(host) + this.outPut.getLineDelimiter());
                }
                catch (UnknownHostException unknownHostException) {
                    this.hostAdrs.add(null);
                    this.outPut.append(String.valueOf(Messages.getString("ReachabilityTestDialog.UnknownHostException")) + host + this.outPut.getLineDelimiter());
                }
            }
            this.outPut.append(this.outPut.getLineDelimiter());
            int i = 0;
            while (i < this.hostAdrs.size()) {
                InetAddress tmpAdr = this.hostAdrs.get(i);
                if (tmpAdr != null) {
                    ReachabilityHostJob pingJob = new ReachabilityHostJob(tmpAdr, number, delay, this.outPut, this.tableOutPut, this.itemStrings[i], i, (ReachabilityTest)this.test);
                    pingJob.schedule();
                    this.pingJobs.add(pingJob);
                } else {
                    this.itemStrings[i][1] = Messages.getString("ReachabilityTestDialog.n_a");
                    this.itemStrings[i][2] = Messages.getString("ReachabilityTestDialog.n_a");
                    this.itemStrings[i][3] = Messages.getString("ReachabilityTestDialog.n_a");
                    this.itemStrings[i][4] = Messages.getString("ReachabilityTestDialog.n_a");
                    this.itemStrings[i][5] = Messages.getString("ReachabilityTestDialog.n_a");
                    this.tableOutPut.clear(i);
                }
                ++i;
            }
        }
    }

    private void clearItemString() {
        int i = 0;
        while (i < this.hostNames.size()) {
            int j = 1;
            while (j < 6) {
                this.itemStrings[i][j] = null;
                ++j;
            }
            ++i;
        }
        this.tableOutPut.clearAll();
    }

    protected void clearLogs() {
        this.clearItemString();
        this.outPut.setText("");
    }
}

