/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.Preferences;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementManager;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatusListener;
import eu.geclipse.ui.decorators.GridJobDecorator;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.ActionGroupManager;
import eu.geclipse.ui.internal.actions.FilterActions;
import eu.geclipse.ui.internal.actions.JobViewActions;
import eu.geclipse.ui.providers.JobViewLabelProvider;
import eu.geclipse.ui.views.ElementManagerViewPart;
import eu.geclipse.ui.views.Messages;
import eu.geclipse.ui.views.filters.GridFilterConfigurationsManager;
import eu.geclipse.ui.views.filters.IFilterConfigurationListener;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import eu.geclipse.ui.views.filters.JobViewFilterConfiguration;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GridJobView
extends ElementManagerViewPart
implements IGridJobStatusListener,
IFilterConfigurationListener {
    private static String XML_MEMENTO_FILTERS = "Filters";
    private static String XML_MEMENTO_COLUMNS = "GridJobViewColumns";
    private static String XML_MEMENTO_COLUMN_WIDTH = "ColumnWidth%d";
    private static String XML_MEMENTO_COLUMN_SORTED = "SortedBy";
    private static String XML_MEMENTO_COLUMN_SORTED_DIRECTON = "SortedDirection";
    private static String PREFERENCE_NAME_FILTERS = "GridJobViewFilters";
    private static String PREFERENCE_NAME_COLUMNS = "GridJobViewColumns";
    JobViewActions jobActions;
    private GridFilterConfigurationsManager filterConfigurationsManager;

    public void dispose() {
        GridModel.getJobManager().removeJobStatusListener((IGridJobStatusListener)this);
        if (this.filterConfigurationsManager != null) {
            this.filterConfigurationsManager.removeConfigurationListener(this);
        }
        this.savePreferences();
        super.dispose();
    }

    public void statusChanged(IGridJob job) {
    }

    public void statusUpdated(IGridJob job) {
        GridJobDecorator decorator = GridJobDecorator.getDecorator();
        if (decorator != null) {
            decorator.refresh((IGridElement)job);
        }
    }

    protected IGridElementManager getManager() {
        return GridModel.getJobManager();
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new JobViewLabelProvider();
    }

    protected boolean createTreeColumns(Tree tree) {
        super.createTreeColumns(tree);
        TreeColumn statusColumn = new TreeColumn(tree, 0);
        statusColumn.setText(Messages.getString("GridJobView.status_column"));
        statusColumn.setAlignment(16384);
        statusColumn.setWidth(100);
        TreeColumn reasonColumn = new TreeColumn(tree, 0);
        reasonColumn.setText(Messages.getString("GridJobView.reason_column"));
        reasonColumn.setAlignment(16384);
        reasonColumn.setWidth(100);
        TreeColumn submissionTimeColumn = new TreeColumn(tree, 0);
        submissionTimeColumn.setText(Messages.getString("GridJobView.columnSubmitted"));
        submissionTimeColumn.setWidth(120);
        TreeColumn lastUpdateColumn = new TreeColumn(tree, 0);
        lastUpdateColumn.setText(Messages.getString("GridJobView.last_update_column"));
        lastUpdateColumn.setAlignment(16384);
        lastUpdateColumn.setWidth(120);
        TreeColumn idColumn = new TreeColumn(tree, 0);
        idColumn.setText(Messages.getString("GridJobView.id_column"));
        idColumn.setAlignment(16384);
        idColumn.setWidth(200);
        tree.setSortColumn(submissionTimeColumn);
        return true;
    }

    protected void contributeAdditionalActions(ActionGroupManager groups) {
        IWorkbenchPartSite site = this.getSite();
        this.jobActions = new JobViewActions((IWorkbenchSite)site);
        groups.addGroup(this.jobActions);
        groups.addGroup(new FilterActions((IWorkbenchSite)this.getSite(), this.filterConfigurationsManager));
        super.contributeAdditionalActions(groups);
    }

    public void init(IViewSite site, IMemento mem) throws PartInitException {
        super.init(site, mem);
        GridModel.getJobManager().addJobStatusListener((IGridJobStatusListener)this);
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "eu.geclipse.core");
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (GridJobView.this.jobActions != null) {
                    GridJobView.this.jobActions.setJobsUpdateStatus(Preferences.getUpdateJobsStatus());
                }
            }
        });
    }

    protected void initViewer(StructuredViewer sViewer) {
        super.initViewer(sViewer);
        this.createFilterConfigurationsManager(sViewer);
        this.readPreferences();
    }

    private void createFilterConfigurationsManager(StructuredViewer sViewer) {
        this.filterConfigurationsManager = new GridFilterConfigurationsManager("JobView"){

            public IGridFilterConfiguration createConfiguration(String name) {
                return new JobViewFilterConfiguration(name);
            }
        };
        this.filterConfigurationsManager.addConfigurationListener(this);
    }

    public void configurationChanged() {
    }

    public void filterConfigurationSelected(ViewerFilter[] filters) {
        if (this.getViewer() != null) {
            this.getViewer().setFilters(filters);
        }
    }

    private void savePreferences() {
        org.eclipse.core.runtime.Preferences preferences = Activator.getDefault().getPluginPreferences();
        this.saveFilters(preferences);
        Activator.getDefault().savePluginPreferences();
    }

    private void saveFilters(org.eclipse.core.runtime.Preferences preferences) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)XML_MEMENTO_FILTERS);
        if (this.filterConfigurationsManager != null) {
            this.filterConfigurationsManager.saveState((IMemento)memento);
        }
        preferences.setValue(PREFERENCE_NAME_FILTERS, this.getMementoString(memento));
    }

    private String getMementoString(XMLMemento memento) {
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException exc) {
            Activator.logException(exc);
        }
        return writer.toString();
    }

    private void readPreferences() {
        org.eclipse.core.runtime.Preferences pluginPreferences = Activator.getDefault().getPluginPreferences();
        this.readFilters(pluginPreferences);
        this.readColumns((IMemento)this.createMemento(pluginPreferences.getString(PREFERENCE_NAME_COLUMNS)));
    }

    private void readFilters(org.eclipse.core.runtime.Preferences preferences) {
        XMLMemento memento = this.createMemento(preferences.getString(PREFERENCE_NAME_FILTERS));
        if (memento != null) {
            this.filterConfigurationsManager.readState((IMemento)memento);
        }
    }

    private XMLMemento createMemento(String string) {
        XMLMemento memento = null;
        if (string != null && string.length() > 0) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(string));
            }
            catch (WorkbenchException exception) {
                Activator.logException(exception);
            }
        }
        return memento;
    }

    private void saveColumns(IMemento parent) {
        IMemento memento = parent.createChild(XML_MEMENTO_COLUMNS);
        TreeViewer vwr = (TreeViewer)this.getViewer();
        Tree tree = vwr.getTree();
        int colNr = 0;
        int sorted = 0;
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            memento.putInteger(String.format(XML_MEMENTO_COLUMN_WIDTH, colNr), column.getWidth());
            if (tree.getSortColumn().equals(column)) {
                sorted = colNr;
            }
            ++colNr;
            ++n2;
        }
        memento.putInteger(XML_MEMENTO_COLUMN_SORTED, sorted);
        memento.putInteger(XML_MEMENTO_COLUMN_SORTED_DIRECTON, tree.getSortDirection());
    }

    private void readColumns(IMemento parent) {
        IMemento memento;
        int sortedDirection = 1024;
        TreeViewer vwr = (TreeViewer)this.getViewer();
        Tree tree = vwr.getTree();
        TreeColumn sortedColumn = tree.getColumn(5);
        if (parent != null && (memento = parent.getChild(XML_MEMENTO_COLUMNS)) != null) {
            int colNr = 0;
            TreeColumn[] treeColumnArray = tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                Integer width = memento.getInteger(String.format(XML_MEMENTO_COLUMN_WIDTH, colNr));
                if (width != null) {
                    column.setWidth(width.intValue());
                }
                ++colNr;
                ++n2;
            }
            Integer sortedColumnInt = memento.getInteger(XML_MEMENTO_COLUMN_SORTED);
            Integer sortDirectionInt = memento.getInteger(XML_MEMENTO_COLUMN_SORTED_DIRECTON);
            if (sortedColumnInt != null && sortDirectionInt != null && sortedColumnInt < tree.getColumnCount()) {
                sortedColumn = tree.getColumn(sortedColumnInt.intValue());
                sortedDirection = sortDirectionInt;
            }
        }
        tree.setSortColumn(sortedColumn);
        tree.setSortDirection(sortedDirection);
    }

    public void saveState(IMemento mem) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)XML_MEMENTO_COLUMNS);
        this.saveColumns((IMemento)memento);
        Activator.getDefault().getPluginPreferences().setValue(PREFERENCE_NAME_COLUMNS, this.getMementoString(memento));
        super.saveState(mem);
    }

    public boolean isDragSource(IGridElement element) {
        return element instanceof IGridConnectionElement;
    }
}

