/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views;

import eu.geclipse.core.IGridVisualisationWindow;
import eu.geclipse.core.model.IGridVisualisation;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.views.Messages;
import eu.geclipse.ui.visualisation.AbstractVisualisationWindow;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class VisualisationView
extends ViewPart {
    protected boolean newTabOn = false;
    protected IAction checkBtnAction = null;
    private final int allowedNumOfTabs = 10;
    private CTabFolder cTabFolder;
    private IGridVisualisation visResource = null;

    private void createActions() {
        ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
        Image image = imgReg.get("toggleTabBtn");
        ImageDescriptor toggleTabBtnImage = ImageDescriptor.createFromImage((Image)image);
        this.checkBtnAction = new Action(Messages.getString("VisualisationView.switchToUpdatesIntoTheSameTab"), 2){

            public boolean isChecked() {
                return VisualisationView.this.newTabOn;
            }

            public void run() {
                if (!VisualisationView.this.checkBtnAction.isChecked()) {
                    VisualisationView.this.newTabOn = true;
                    VisualisationView.this.checkBtnAction.setToolTipText(Messages.getString("VisualisationView.switchToNewTabWhenUpdating"));
                    VisualisationView.this.checkBtnAction.setChecked(false);
                } else {
                    VisualisationView.this.newTabOn = false;
                    VisualisationView.this.checkBtnAction.setToolTipText(Messages.getString("VisualisationView.switchToUpdatesIntoTheSameTab"));
                    VisualisationView.this.checkBtnAction.setChecked(true);
                }
            }
        };
        this.checkBtnAction.setToolTipText(Messages.getString("VisualisationView.switchToUpdatesIntoTheSameTab"));
        this.checkBtnAction.setImageDescriptor(toggleTabBtnImage);
    }

    public void createPartControl(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.cTabFolder = new CTabFolder(parent, 0x800400);
        this.cTabFolder.setLayoutData((Object)gridData);
        this.cTabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                CTabFolder folder = (CTabFolder)event.widget;
                CTabItem item = folder.getSelection();
                if (item != null && item.getControl() != null) {
                    item.getControl().setFocus();
                }
            }
        });
        this.cTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
            }
        });
        this.createActions();
        this.createToolBar();
    }

    private void createToolBar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add(this.checkBtnAction);
    }

    public CTabFolder getCTabFolder() {
        return this.cTabFolder;
    }

    public CTabItem getCTabItem(boolean onRenderAction) {
        CTabItem cTabItem = this.cTabFolder != null ? this.getTab(onRenderAction) : null;
        return cTabItem;
    }

    private CTabItem getTab(boolean onRenderAction) {
        CTabItem tabItem = null;
        if (!this.checkBtnAction.isChecked() && onRenderAction) {
            if (this.cTabFolder.getItemCount() < 10) {
                tabItem = new CTabItem(this.cTabFolder, 64);
                this.cTabFolder.setSelection(tabItem);
            } else {
                ProblemException pe = new ProblemException("eu.geclipse.ui.reachedMaximumAllowedOpenedTabsProblem", "eu.geclipse.ui");
                ProblemDialog.openProblem(null, Messages.getString("VisualisationView.dialogTitle"), Messages.getString("VisualisationView.maxNumOfTabsOpenedErrorMessage"), pe);
            }
        } else {
            tabItem = this.cTabFolder.getSelection() != null ? this.cTabFolder.getSelection() : new CTabItem(this.cTabFolder, 64);
            this.cTabFolder.setSelection(tabItem);
        }
        return tabItem;
    }

    public boolean render(String resFileNameExt, String visType) {
        IExtension[] extensions;
        if (this.visResource == null) {
            return false;
        }
        IGridVisualisationWindow winImpl = null;
        IExtensionPoint p = Platform.getExtensionRegistry().getExtensionPoint("eu.geclipse.ui.visualisationWindow");
        IExtension[] iExtensionArray = extensions = p.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("window".equals(element.getName()) && element.getAttribute("fileExtension").compareTo(resFileNameExt) == 0 && (element.getAttribute("type") == null || element.getAttribute("type").compareTo(visType) == 0)) {
                    try {
                        winImpl = (IGridVisualisationWindow)element.createExecutableExtension("class");
                        ((AbstractVisualisationWindow)winImpl).init((Composite)this.cTabFolder, 0x1000000);
                        break;
                    }
                    catch (CoreException e) {
                        Activator.logException(e);
                        return false;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return this.visResource.render(visType, winImpl);
    }

    public void setFocus() {
        if (this.cTabFolder != null) {
            this.cTabFolder.setFocus();
        }
    }

    public void setVisResource(IGridVisualisation resource) {
        this.visResource = resource;
    }

    public boolean isSuccess() {
        return false;
    }
}

