/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.filters.AbstractGridViewerFilter;
import eu.geclipse.ui.views.filters.IGridFilter;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;

public class JobStatusFilter
extends AbstractGridViewerFilter {
    private static final String MEMENTO_TYPE_STATUS = "Status";
    private static final String MEMENTO_KEY_STATUS_SHOW = "Show";
    private HashMap<Integer, Boolean> statusMap = new HashMap();

    public IGridFilter makeClone() throws CloneNotSupportedException {
        JobStatusFilter newFilter = (JobStatusFilter)super.clone();
        newFilter.statusMap = (HashMap)this.statusMap.clone();
        return newFilter;
    }

    public void setStatusState(int jobStatus, boolean showOnView) {
        this.statusMap.put(jobStatus, showOnView);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean showOnView = true;
        if (element instanceof IGridJob) {
            IGridJob job = (IGridJob)element;
            int jobStatus = job.getJobStatus().getType();
            Boolean showOnViewBool = this.statusMap.get(jobStatus);
            showOnView = showOnViewBool == null ? this.getStatusState(128) : showOnViewBool.booleanValue();
        }
        return showOnView;
    }

    public boolean getStatusState(int jobStatus) {
        Boolean showOnView = this.statusMap.get(jobStatus);
        return showOnView == null || showOnView != false;
    }

    public void saveState(IMemento filterMemento) {
        for (Integer status : this.statusMap.keySet()) {
            IMemento statusMemento = filterMemento.createChild(MEMENTO_TYPE_STATUS, status.toString());
            statusMemento.putInteger(MEMENTO_KEY_STATUS_SHOW, this.getStatusState(status) ? 1 : 0);
        }
    }

    public boolean isEnabled() {
        boolean enabled = false;
        Iterator<Integer> keysIterator = this.statusMap.keySet().iterator();
        while (keysIterator.hasNext() && !enabled) {
            enabled |= this.statusMap.get(keysIterator.next()) == false;
        }
        return enabled;
    }

    public void readState(IMemento filterMemento) {
        IMemento[] statusMementos;
        IMemento[] iMementoArray = statusMementos = filterMemento.getChildren(MEMENTO_TYPE_STATUS);
        int n = statusMementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento statusMemento = iMementoArray[n2];
            Integer statusValue = Integer.valueOf(statusMemento.getID());
            Integer showOnView = statusMemento.getInteger(MEMENTO_KEY_STATUS_SHOW);
            if (statusValue != null && showOnView != null) {
                this.setStatusState(statusValue, showOnView != 0);
            }
            ++n2;
        }
    }

    static String getId() {
        return "JobStatusFilter";
    }

    public String getFilterId() {
        return JobStatusFilter.getId();
    }
}

