/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.filters;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.filters.AbstractGridViewerFilter;
import eu.geclipse.ui.views.filters.IGridFilter;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;

public class JobSubmissionTimeFilter
extends AbstractGridViewerFilter {
    private static String MEMENTO_KEY_AFTERDATE = "AfterDate";
    private static String MEMENTO_KEY_BEFOREDATE = "BeforeDate";
    private Date afterDate;
    private Date beforeDate;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IGridJob job;
        boolean showOnView = true;
        if (element instanceof IGridJob && (job = (IGridJob)element).getSubmissionTime() != null) {
            if (this.afterDate != null) {
                showOnView &= job.getSubmissionTime().after(this.afterDate);
            }
            if (this.beforeDate != null) {
                showOnView &= job.getSubmissionTime().before(this.beforeDate);
            }
        }
        return showOnView;
    }

    public String getFilterId() {
        return JobSubmissionTimeFilter.getId();
    }

    public boolean isEnabled() {
        return this.afterDate != null || this.beforeDate != null;
    }

    public IGridFilter makeClone() throws CloneNotSupportedException {
        JobSubmissionTimeFilter newFilter = (JobSubmissionTimeFilter)super.clone();
        if (this.afterDate != null) {
            newFilter.afterDate = (Date)this.afterDate.clone();
        }
        if (this.beforeDate != null) {
            newFilter.beforeDate = (Date)this.beforeDate.clone();
        }
        return newFilter;
    }

    public void readState(IMemento filterMemento) {
        this.afterDate = this.readDate(filterMemento, MEMENTO_KEY_AFTERDATE);
        this.beforeDate = this.readDate(filterMemento, MEMENTO_KEY_BEFOREDATE);
    }

    public void saveState(IMemento filterMemento) {
        if (this.afterDate != null) {
            this.saveDate(filterMemento, MEMENTO_KEY_AFTERDATE, this.afterDate);
        }
        if (this.beforeDate != null) {
            this.saveDate(filterMemento, MEMENTO_KEY_BEFOREDATE, this.beforeDate);
        }
    }

    static String getId() {
        return "JobSubmissionTimeFilter";
    }

    public void setDates(Date newAfterDate, Date newBeforeDate) {
        this.afterDate = newAfterDate;
        this.beforeDate = newBeforeDate;
    }

    public Date getAfterDate() {
        return this.afterDate;
    }

    public Date getBeforeDate() {
        return this.beforeDate;
    }
}

