/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.jobs.GridJobStatus;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsFactory;
import eu.geclipse.ui.views.jobdetails.JobDetailSectionsManager;
import eu.geclipse.ui.views.jobdetails.JobTextDetail;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridJobDetailsFactory
implements IJobDetailsFactory {
    @Override
    public List<IJobDetail> getDetails(IGridJob gridJob, JobDetailSectionsManager sectionManager) {
        ArrayList<IJobDetail> details = new ArrayList<IJobDetail>(20);
        details.add(this.createName(sectionManager));
        details.add(this.createIdentifier(sectionManager));
        details.add(this.createStatus(sectionManager));
        details.add(this.createReason(sectionManager));
        details.add(this.createStatusUpdatedTime(sectionManager));
        details.add(this.createExecutable(sectionManager));
        details.add(this.createExecArgs(sectionManager));
        details.add(this.createInput(sectionManager));
        details.add(this.createOutput(sectionManager));
        details.add(this.createDescription(sectionManager));
        return details;
    }

    private IJobDetail createName(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionGeneral(), Messages.GridJobDetailsFactory_name){

            protected String getValue(IGridJob gridJob) {
                return gridJob.getJobName();
            }
        };
    }

    private IJobDetail createIdentifier(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionGeneral(), Messages.GridJobDetailsFactory_id){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getID() != null) {
                    value = gridJob.getID().getJobID();
                }
                return value;
            }
        };
    }

    private IJobDetail createStatus(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionGeneral(), Messages.GridJobDetailsFactory_status){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobStatus() != null) {
                    value = gridJob.getJobStatus().getName();
                }
                return value;
            }
        };
    }

    private IJobDetail createReason(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionGeneral(), Messages.GridJobDetailsFactory_reason){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobStatus() != null && gridJob.getJobStatus().getReason() != null && gridJob.getJobStatus().getReason().length() > 0) {
                    value = gridJob.getJobStatus().getReason();
                }
                return value;
            }
        };
    }

    private IJobDetail createStatusUpdatedTime(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionGeneral(), Messages.GridJobDetailsFactory_lastUpdateTime){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobStatus() != null && gridJob.getJobStatus().getLastUpdateTime() != null) {
                    value = DateFormat.getDateTimeInstance().format(gridJob.getJobStatus().getLastUpdateTime());
                }
                return value;
            }
        };
    }

    private IJobDetail createExecutable(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionApplication(), Messages.GridJobDetailsFactory_executable){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobDescription() != null) {
                    value = gridJob.getJobDescription().getExecutable();
                }
                return value;
            }
        };
    }

    private IJobDetail createExecArgs(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionApplication(), Messages.GridJobDetailsFactory_arguments){

            protected String getValue(IGridJob gridJob) {
                String valueString = null;
                if (gridJob.getJobDescription() != null && gridJob.getJobDescription().getExecutableArguments() != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    List argList = gridJob.getJobDescription().getExecutableArguments();
                    for (String argString : argList) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(argString);
                    }
                    valueString = stringBuilder.toString();
                }
                return valueString;
            }
        };
    }

    private IJobDetail createInput(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionApplication(), Messages.GridJobDetailsFactory_input){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobDescription() != null) {
                    value = gridJob.getJobDescription().getStdInputFileName();
                }
                return value;
            }
        };
    }

    private IJobDetail createOutput(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionApplication(), Messages.GridJobDetailsFactory_output){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobDescription() != null) {
                    value = gridJob.getJobDescription().getStdOutputFileName();
                }
                return value;
            }
        };
    }

    private IJobDetail createDescription(JobDetailSectionsManager sectionManager) {
        return new JobTextDetail(sectionManager.getSectionApplication(), Messages.GridJobDetailsFactory_description){

            protected String getValue(IGridJob gridJob) {
                String value = null;
                if (gridJob.getJobDescription() != null) {
                    value = gridJob.getJobDescription().getDescription();
                }
                return value;
            }
        };
    }

    @Override
    public boolean shouldUpdateJobStatus(IGridJob gridJob) {
        boolean updateJobStatus = false;
        IGridJobStatus jobStatus = gridJob.getJobStatus();
        if (jobStatus != null) {
            updateJobStatus = jobStatus.getClass().equals(GridJobStatus.class);
        }
        return updateJobStatus;
    }
}

