/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.ui.Extensions;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsFactory;
import eu.geclipse.ui.views.jobdetails.IJobDetailsSection;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import eu.geclipse.ui.views.jobdetails.JobDetailsSection;
import eu.geclipse.ui.views.jobdetails.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobDetailSectionsManager {
    private static int nextId = 1;
    private static Integer generalSectionId;
    private static Integer applicationSectionId;
    private static HashSet<IGridJobID> updatedJobs;
    private Composite parent;
    private Map<Integer, IJobDetailsSection> sectionsMap = new HashMap<Integer, IJobDetailsSection>();
    private List<IJobDetail> currentDetails;
    private IViewConfiguration viewConfiguration;

    static {
        updatedJobs = new HashSet();
    }

    public JobDetailSectionsManager(Composite parent, IViewConfiguration viewConfiguration) {
        this.parent = parent;
        this.viewConfiguration = viewConfiguration;
    }

    private static int getNextId() {
        return nextId++;
    }

    void refresh(IGridJob inputJob) {
        List<IJobDetailsFactory> factories = null;
        if (inputJob != null) {
            Class<?> statusClass = inputJob.getJobStatus() != null ? inputJob.getJobStatus().getClass() : null;
            factories = Extensions.getJobDetailsFactories(inputJob.getClass(), statusClass);
        }
        List<IJobDetail> details = this.getDetails(inputJob, factories);
        List<IJobDetailsSection> sections = this.getSections(details);
        this.disposeNotUsedDetails(details);
        this.dispatchDetailsToSections(details);
        this.disposeNotUsedSections();
        for (IJobDetailsSection section : sections) {
            section.refresh(inputJob, this.parent);
        }
        this.currentDetails = details;
        this.scheduleJobStatusUpdate(factories, inputJob);
    }

    private void scheduleJobStatusUpdate(List<IJobDetailsFactory> factories, final IGridJob inputJob) {
        IGridJobID id;
        if (factories != null && inputJob != null && !updatedJobs.contains(id = inputJob.getID())) {
            for (IJobDetailsFactory jobDetailsFactory : factories) {
                if (!jobDetailsFactory.shouldUpdateJobStatus(inputJob)) continue;
                Job backgroundJob = new Job(String.format(Messages.JobDetailSectionsManager_taskNameUpdateJobStatus, inputJob.getJobName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        IStatus status = Status.OK_STATUS;
                        IGridJobStatus oldStatus = inputJob.getJobStatus();
                        inputJob.updateJobStatus(monitor, true);
                        GridModel.getJobManager().jobStatusChanged(inputJob, oldStatus);
                        return status;
                    }
                };
                updatedJobs.add(id);
                backgroundJob.schedule();
                break;
            }
        }
    }

    private List<IJobDetail> getDetails(IGridJob gridJob, List<IJobDetailsFactory> factories) {
        ArrayList<IJobDetail> details = new ArrayList<IJobDetail>(100);
        if (gridJob != null) {
            for (IJobDetailsFactory jobDetailsFactory : factories) {
                details.addAll(jobDetailsFactory.getDetails(gridJob, this));
            }
        }
        return details;
    }

    private List<IJobDetailsSection> getSections(List<IJobDetail> details) {
        ArrayList<IJobDetailsSection> sections = new ArrayList<IJobDetailsSection>();
        for (IJobDetail detail : details) {
            if (sections.contains(detail.getSection())) continue;
            sections.add(detail.getSection());
        }
        Collections.sort(sections, new Comparator<IJobDetailsSection>(){

            @Override
            public int compare(IJobDetailsSection section1, IJobDetailsSection section2) {
                return section1.getOrder() - section2.getOrder();
            }
        });
        return sections;
    }

    public IJobDetailsSection getSection(Integer sectionId) {
        return this.sectionsMap.get(sectionId);
    }

    public Integer createSection(String name, int order, boolean lazy) {
        Integer id = JobDetailSectionsManager.getNextId();
        JobDetailsSection section = new JobDetailsSection(name, order, this.viewConfiguration, lazy);
        this.sectionsMap.put(id, section);
        return id;
    }

    public Integer createSection(String name, int order) {
        return this.createSection(name, order, false);
    }

    public IJobDetailsSection getSectionGeneral() {
        IJobDetailsSection section = this.getSection(generalSectionId);
        if (section == null) {
            generalSectionId = this.createSection(Messages.JobDetailSectionsManager_general, SectionOrder.GENERAL.getOrder());
            section = this.getSection(generalSectionId);
        }
        return section;
    }

    public IJobDetailsSection getSectionApplication() {
        IJobDetailsSection section = this.getSection(applicationSectionId);
        if (section == null) {
            applicationSectionId = this.createSection(Messages.JobDetailSectionsManager_application, SectionOrder.APPLICATION.getOrder());
            section = this.getSection(applicationSectionId);
        }
        return section;
    }

    private void dispatchDetailsToSections(List<IJobDetail> details) {
        if (details != null) {
            for (IJobDetail detail : details) {
                detail.getSection().addDetail(detail);
            }
        }
    }

    private void disposeNotUsedDetails(List<IJobDetail> newDetails) {
        if (this.currentDetails != null) {
            for (IJobDetail jobDetail : this.currentDetails) {
                if (this.findDetailById(newDetails, jobDetail.getId(), jobDetail.getSection()) != null) continue;
                jobDetail.dispose();
                jobDetail.getSection().removeDetail(jobDetail);
            }
        }
    }

    private void disposeNotUsedSections() {
        for (Integer sectionId : this.sectionsMap.keySet()) {
            IJobDetailsSection section = this.getSection(sectionId);
            if (section == null || section.getDetails().size() != 0) continue;
            section.dispose();
        }
    }

    private IJobDetail findDetailById(List<IJobDetail> details, String detailId, IJobDetailsSection section) {
        IJobDetail foundDetail = null;
        Iterator<IJobDetail> iterator = details.iterator();
        while (iterator.hasNext() && foundDetail == null) {
            IJobDetail jobDetail = iterator.next();
            if (jobDetail.getSection() != section || !jobDetail.getId().equals(detailId)) continue;
            foundDetail = jobDetail;
        }
        return foundDetail;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SectionOrder {
        GENERAL,
        APPLICATION;


        int getOrder() {
            return this.ordinal();
        }
    }
}

