/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.views.jobdetails;

import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.views.jobdetails.IJobDetail;
import eu.geclipse.ui.views.jobdetails.IJobDetailsSection;
import eu.geclipse.ui.views.jobdetails.IViewConfiguration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobDetailsSection
implements IJobDetailsSection {
    private String name;
    private int order;
    private Section sectionWidget;
    private List<IJobDetail> details = new LinkedList<IJobDetail>();
    IViewConfiguration viewConfiguration;
    private boolean lazy;

    public JobDetailsSection(String name, int order, IViewConfiguration viewConfiguration, boolean lazy) {
        this.name = name;
        this.order = order;
        this.viewConfiguration = viewConfiguration;
        this.lazy = lazy;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void refresh(IGridJob gridJob, Composite parent) {
        boolean atLeastOneDetailSpecified = false;
        if (!this.isWidgetCreated()) {
            this.createWidgets(parent, this.viewConfiguration.getFormToolkit());
        }
        if (!this.lazy || this.sectionWidget.isExpanded()) {
            for (IJobDetail detail : this.details) {
                atLeastOneDetailSpecified |= detail.refresh(gridJob, (Composite)this.sectionWidget.getClient(), this.viewConfiguration);
            }
        }
        this.setVisible(this.viewConfiguration.isShowEmptyEnabled() || atLeastOneDetailSpecified || this.lazy);
    }

    private void createWidgets(Composite parent, FormToolkit formToolkit) {
        this.sectionWidget = formToolkit.createSection(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        this.sectionWidget.setLayoutData((Object)gridData);
        this.sectionWidget.setText(this.name);
        this.sectionWidget.setExpanded(!this.lazy);
        Composite clientComposite = formToolkit.createComposite((Composite)this.sectionWidget);
        clientComposite.setLayout((Layout)new GridLayout(2, false));
        this.sectionWidget.setClient((Control)clientComposite);
        if (this.lazy) {
            this.sectionWidget.addExpansionListener(this.createExpansionListener());
        }
    }

    private boolean isWidgetCreated() {
        return this.sectionWidget != null && !this.sectionWidget.isDisposed();
    }

    @Override
    public void addDetail(IJobDetail detail) {
        IJobDetail oldDetail = null;
        ListIterator<IJobDetail> iterator = this.details.listIterator();
        while (iterator.hasNext() && oldDetail == null) {
            IJobDetail curDetail = iterator.next();
            if (!curDetail.getId().equals(detail.getId()) || !curDetail.getClass().equals(detail.getClass())) continue;
            oldDetail = curDetail;
        }
        if (oldDetail == null) {
            this.details.add(detail);
        } else {
            detail.reuseWidgets(oldDetail);
            iterator.set(detail);
        }
    }

    @Override
    public void removeDetail(IJobDetail detail) {
        this.details.remove(detail);
    }

    @Override
    public void dispose() {
        if (this.isWidgetCreated()) {
            this.sectionWidget.dispose();
            this.sectionWidget = null;
        }
    }

    private void setVisible(boolean visible) {
        this.sectionWidget.setVisible(visible);
        GridData gridData = (GridData)this.sectionWidget.getLayoutData();
        gridData.exclude = !visible;
    }

    @Override
    public List<IJobDetail> getDetails() {
        return this.details;
    }

    @Override
    public IGridJob getInputJob() {
        return this.viewConfiguration.getInputJob();
    }

    private IExpansionListener createExpansionListener() {
        return new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    JobDetailsSection.this.viewConfiguration.refresh();
                }
            }
        };
    }

    @Override
    public IViewConfiguration getViewConfiguration() {
        return this.viewConfiguration;
    }
}

