/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.IDropDownEntry;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropDownExtensionAction<UserDataType>
extends Action
implements IMenuCreator {
    UserDataType userData;
    private String extensionPointId;

    public DropDownExtensionAction(UserDataType userData, String extensionPointId) {
        this.userData = userData;
        this.extensionPointId = extensionPointId;
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.setMenuCreator(this);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        Action[] terminalFactories;
        Menu menu = new Menu(parent);
        Action[] actionArray = terminalFactories = this.getFactoryList();
        int n = terminalFactories.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(menu, -1);
            ++n2;
        }
        return menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private Action[] getFactoryList() {
        LinkedList<1> list = new LinkedList<1>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(this.extensionPointId);
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("dropDownEntry".equals(element.getName())) {
                        try {
                            String name = element.getAttribute("label");
                            Object object = element.createExecutableExtension("class");
                            if (object instanceof IDropDownEntry) {
                                final IDropDownEntry factory = (IDropDownEntry)object;
                                String iconName = element.getAttribute("icon");
                                ImageDescriptor icon = null;
                                if (iconName != null) {
                                    String pluginId = element.getContributor().getName();
                                    icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconName);
                                }
                                final ImageDescriptor finalIcon = icon;
                                Action action = new Action(){

                                    public ImageDescriptor getImageDescriptor() {
                                        return finalIcon;
                                    }

                                    public void run() {
                                        factory.action(DropDownExtensionAction.this.userData);
                                    }
                                };
                                action.setText(name);
                                action.setImageDescriptor(icon);
                                list.add(action);
                            }
                        }
                        catch (CoreException coreEx) {
                            Activator.logException(coreEx);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return list.toArray(new Action[0]);
    }
}

