/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnection;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridPreferences;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.Extensions;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ConnectionViewContentProvider;
import eu.geclipse.ui.providers.GridModelLabelProvider;
import eu.geclipse.ui.widgets.Messages;
import eu.geclipse.ui.widgets.StoredCombo;
import eu.geclipse.ui.wizards.IConnectionTokenValidator;
import eu.geclipse.ui.wizards.IConnectionUriProcessor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Tree;

public class GridConnectionDefinitionComposite
extends Composite {
    private static final String FS_GECL = "gecl";
    private static final String FS_NULL = EFS.getNullFileSystem().getScheme();
    private static final String KEY_FIELD_ACTIVE = "field_enablement";
    private static final String SEPARATOR = ":";
    protected TreeViewer viewer;
    protected String errorMessage;
    protected Link pathLink;
    private String currentURIType;
    private Label schemeLabel;
    private Label uriLabel;
    private Label schemeSpecificPartLabel;
    private Label authorityLabel;
    private Label userInfoLabel;
    private Label hostLabel;
    private Label portLabel;
    private Label pathLabel;
    private Label queryLabel;
    private Label fragmentLabel;
    private Combo schemeCombo;
    private StoredCombo uriCombo;
    private StoredCombo schemeSpecificPartCombo;
    private StoredCombo authorityCombo;
    private StoredCombo userInfoCombo;
    private StoredCombo hostCombo;
    private StoredCombo portCombo;
    private StoredCombo pathCombo;
    private StoredCombo queryCombo;
    private StoredCombo fragmentCombo;
    private IConnectionTokenValidator validator;
    private IConnectionUriProcessor processor;
    private List<ModifyListener> listeners;
    private EditorFieldModifyListener modifyListener;
    private IGridContainer mountPoint;

    public GridConnectionDefinitionComposite(IGridContainer mountPoint, Composite parent, int style) {
        super(parent, style);
        this.mountPoint = mountPoint;
        this.modifyListener = new EditorFieldModifyListener(this);
        this.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.setLayoutData(gData);
        this.schemeLabel = new Label((Composite)this, 0);
        this.schemeLabel.setText(Messages.getString("GridConnectionDefinitionComposite.scheme_label"));
        gData = new GridData();
        gData.minimumHeight = 0;
        this.schemeLabel.setLayoutData((Object)gData);
        this.schemeCombo = new Combo((Composite)this, 8);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.minimumHeight = 0;
        this.schemeCombo.setLayoutData((Object)gData);
        this.uriLabel = new Label((Composite)this, 0);
        this.uriCombo = this.createEditorField(this, this.uriLabel, Messages.getString("GridConnectionDefinitionComposite.uri_label"), this.modifyListener);
        this.schemeSpecificPartLabel = new Label((Composite)this, 0);
        this.schemeSpecificPartCombo = this.createEditorField(this, this.schemeSpecificPartLabel, Messages.getString("GridConnectionDefinitionComposite.scheme_spec_part_label"), this.modifyListener);
        this.authorityLabel = new Label((Composite)this, 0);
        this.authorityCombo = this.createEditorField(this, this.authorityLabel, Messages.getString("GridConnectionDefinitionComposite.authority_label"), this.modifyListener);
        this.userInfoLabel = new Label((Composite)this, 0);
        this.userInfoCombo = this.createEditorField(this, this.userInfoLabel, Messages.getString("GridConnectionDefinitionComposite.user_info_label"), this.modifyListener);
        this.hostLabel = new Label((Composite)this, 0);
        this.hostCombo = this.createEditorField(this, this.hostLabel, Messages.getString("GridConnectionDefinitionComposite.host_label"), this.modifyListener);
        this.portLabel = new Label((Composite)this, 0);
        this.portCombo = this.createEditorField(this, this.portLabel, Messages.getString("GridConnectionDefinitionComposite.port_label"), this.modifyListener);
        this.pathLabel = new Label((Composite)this, 0);
        this.pathCombo = this.createEditorField(this, this.pathLabel, Messages.getString("GridConnectionDefinitionComposite.path_label"), this.modifyListener);
        this.queryLabel = new Label((Composite)this, 0);
        this.queryCombo = this.createEditorField(this, this.queryLabel, Messages.getString("GridConnectionDefinitionComposite.query_label"), this.modifyListener);
        this.fragmentLabel = new Label((Composite)this, 0);
        this.fragmentCombo = this.createEditorField(this, this.fragmentLabel, Messages.getString("GridConnectionDefinitionComposite.fragment_label"), this.modifyListener);
        Group browseGroup = new Group((Composite)this, 0);
        browseGroup.setLayout((Layout)new GridLayout(1, false));
        browseGroup.setText(Messages.getString("GridConnectionDefinitionComposite.browser_group_title"));
        gData = new GridData(1808);
        gData.horizontalSpan = 4;
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        browseGroup.setLayoutData((Object)gData);
        this.pathLink = new Link((Composite)browseGroup, 0);
        this.pathLink.setText(Messages.getString("GridConnectionDefinitionComposite.browser_link"));
        gData = new GridData();
        this.pathLink.setLayoutData((Object)gData);
        this.viewer = new TreeViewer((Composite)browseGroup, 2820);
        ConnectionViewContentProvider cProvider = new ConnectionViewContentProvider();
        this.viewer.setContentProvider((IContentProvider)cProvider);
        GridModelLabelProvider lProvider = new GridModelLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)lProvider);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer view, Object parentElement, Object element) {
                boolean result = true;
                if (element instanceof IGridConnectionElement) {
                    result = ((IGridConnectionElement)element).isFolder();
                }
                return result;
            }
        });
        Tree tree = this.viewer.getTree();
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gData);
        this.initializeSchemeCombo(this.schemeCombo);
        this.schemeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GridConnectionDefinitionComposite.this.setupFields();
            }
        });
        this.pathLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridConnectionDefinitionComposite.this.initializeBrowser();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GridConnectionDefinitionComposite.this.handleDoubleClick();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GridConnectionDefinitionComposite.this.handleSelectionChanged(event.getSelection());
            }
        });
        GridModel.getRoot().addGridModelListener(new IGridModelListener(){

            public void gridModelChanged(IGridModelEvent event) {
                GridConnectionDefinitionComposite.this.handleGridModelChanged(event);
            }
        });
        this.setupFields();
        this.modifyListener.setActive(true);
    }

    public void addModifyListener(ModifyListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ModifyListener>();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public URI getURI() {
        String oldErrorMessage = this.getErrorMessage();
        String newErrorMessage = null;
        URI uri = null;
        String scheme = this.schemeCombo.getText();
        try {
            if (this.isActive(this.uriCombo)) {
                uri = new URI(this.uriCombo.getText());
            } else if (this.isActive(this.schemeSpecificPartCombo)) {
                String schemeSpecificPart = this.schemeSpecificPartCombo.getText();
                String fragment = this.isActive(this.fragmentCombo) ? this.fragmentCombo.getText() : null;
                uri = new URI(scheme, schemeSpecificPart, fragment);
            } else if (!this.isActive(this.hostCombo)) {
                String authority = this.authorityCombo.getText();
                String path = this.isActive(this.pathCombo) ? this.pathCombo.getText() : null;
                String query = this.isActive(this.queryCombo) ? this.queryCombo.getText() : null;
                String fragment = this.isActive(this.fragmentCombo) ? this.fragmentCombo.getText() : null;
                uri = new URI(scheme, authority, path, query, fragment);
            } else {
                String userInfo = this.isActive(this.userInfoCombo) ? this.userInfoCombo.getText() : null;
                String host = this.hostCombo.getText();
                int port = this.isActive(this.portCombo) ? Integer.parseInt(this.portCombo.getText()) : -1;
                String path = this.isActive(this.pathCombo) ? this.pathCombo.getText() : null;
                String query = this.isActive(this.queryCombo) ? this.queryCombo.getText() : null;
                String fragment = this.isActive(this.fragmentCombo) ? this.fragmentCombo.getText() : null;
                uri = new URI(scheme, userInfo, host, port, path, query, fragment);
            }
        }
        catch (URISyntaxException uriExc) {
            newErrorMessage = String.valueOf(Messages.getString("GridConnectionDefinitionComposite.invalid_uri_error")) + uriExc.getMessage();
        }
        catch (NumberFormatException nfExc) {
            newErrorMessage = String.valueOf(Messages.getString("GridConnectionDefinitionComposite.invalid_uri_error")) + nfExc.getMessage();
        }
        if (newErrorMessage != null && !newErrorMessage.equals(oldErrorMessage) || oldErrorMessage != null && !oldErrorMessage.equals(newErrorMessage)) {
            this.errorMessage = newErrorMessage;
            this.fireModifyEvent();
        }
        if (this.processor != null) {
            uri = this.processor.processURI(this.mountPoint, uri);
        }
        return uri;
    }

    public boolean isValid() {
        String oldErrorMessage = this.getErrorMessage();
        String newErrorMessage = null;
        if (this.validator != null) {
            if (this.isActive(this.uriCombo)) {
                newErrorMessage = this.validator.validateToken("uri", this.uriCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.schemeSpecificPartCombo)) {
                newErrorMessage = this.validator.validateToken("scheme-specific-part", this.schemeSpecificPartCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.authorityCombo)) {
                newErrorMessage = this.validator.validateToken("authority", this.authorityCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.userInfoCombo)) {
                newErrorMessage = this.validator.validateToken("user-info", this.userInfoCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.hostCombo)) {
                newErrorMessage = this.validator.validateToken("host", this.hostCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.portCombo)) {
                newErrorMessage = this.validator.validateToken("port", this.portCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.pathCombo)) {
                newErrorMessage = this.validator.validateToken("path", this.pathCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.queryCombo)) {
                newErrorMessage = this.validator.validateToken("query", this.queryCombo.getText());
            }
            if (newErrorMessage == null && this.isActive(this.fragmentCombo)) {
                newErrorMessage = this.validator.validateToken("fragment", this.fragmentCombo.getText());
            }
        }
        if (newErrorMessage != null && !newErrorMessage.equals(oldErrorMessage) || oldErrorMessage != null && !oldErrorMessage.equals(newErrorMessage)) {
            this.errorMessage = newErrorMessage;
        }
        return this.errorMessage == null;
    }

    public void removeModifyListener(ModifyListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void setURI(URI uri) {
        this.modifyListener.setActive(false);
        String scheme = uri.getScheme();
        this.schemeCombo.setText(scheme);
        String uris = uri.toString();
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        String authority = uri.getAuthority();
        String userInfo = uri.getUserInfo();
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String query = uri.getQuery();
        String fragment = uri.getFragment();
        this.uriCombo.setDefaultItem(uris != null ? uris : "");
        this.schemeSpecificPartCombo.setDefaultItem(schemeSpecificPart != null ? schemeSpecificPart : "");
        this.authorityCombo.setDefaultItem(authority != null ? authority : "");
        this.userInfoCombo.setDefaultItem(userInfo != null ? userInfo : "");
        this.hostCombo.setDefaultItem(host != null ? host : "");
        this.portCombo.setDefaultItem(port != -1 ? String.valueOf(uri.getPort()) : "");
        this.pathCombo.setDefaultItem(path != null ? path : "");
        this.queryCombo.setDefaultItem(query != null ? query : "");
        this.fragmentCombo.setDefaultItem(fragment != null ? fragment : "");
        this.modifyListener.setActive(true);
        this.updateUI();
    }

    protected void fireModifyEvent() {
        if (this.listeners != null) {
            Event event = new Event();
            event.widget = this;
            ModifyEvent mEvent = new ModifyEvent(event);
            for (ModifyListener l : this.listeners) {
                l.modifyText(mEvent);
            }
        }
    }

    protected void handleDoubleClick() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object object = selection.getFirstElement();
        if (this.viewer.isExpandable(object)) {
            boolean state = this.viewer.getExpandedState(object);
            this.viewer.setExpandedState(object, !state);
        }
    }

    protected void handleGridModelChanged(IGridModelEvent event) {
        if (event.getType() == 1 || event.getType() == 2) {
            this.refreshViewer(event.getSource());
        }
    }

    protected void handleSelectionChanged(ISelection selection) {
        IStructuredSelection sSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (sSelection = (IStructuredSelection)selection).getFirstElement()) != null && object instanceof IGridConnectionElement) {
            IGridConnectionElement element = (IGridConnectionElement)object;
            try {
                IFileStore fileStore = element.getConnectionFileStore();
                GEclipseURI geclURI = new GEclipseURI(fileStore.toURI());
                URI uri = geclURI.toSlaveURI();
                if (this.currentURIType.equals("raw")) {
                    this.uriCombo.setText(uri.toString());
                } else if (this.currentURIType.equals("opaque")) {
                    this.schemeSpecificPartCombo.setText(uri.getSchemeSpecificPart());
                } else if (this.currentURIType.equals("hierarchical") || this.currentURIType.equals("server")) {
                    this.pathCombo.setText(uri.getPath());
                }
            }
            catch (CoreException coreException) {
                this.errorMessage = Messages.getString("GridConnectionDefinitionComposite.invalid_path_error");
                this.fireModifyEvent();
            }
        }
    }

    protected void initializeBrowser() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                GridConnectionDefinitionComposite.this.pathLink.setEnabled(false);
                URI slaveURI = GridConnectionDefinitionComposite.this.getURI();
                if (slaveURI != null) {
                    try {
                        try {
                            GEclipseURI geclURI = new GEclipseURI(slaveURI);
                            URI masterURI = geclURI.toMasterURI();
                            IGridPreferences preferences = GridModel.getPreferences();
                            IGridConnection connection = preferences.createTemporaryConnection(masterURI);
                            GridConnectionDefinitionComposite.this.viewer.setInput((Object)connection);
                        }
                        catch (ProblemException pExc) {
                            GridConnectionDefinitionComposite.this.errorMessage = Messages.getString("GridConnectionDefinitionComposite.invalid_temp_conn_error");
                            GridConnectionDefinitionComposite.this.fireModifyEvent();
                            ProblemDialog.openProblem(GridConnectionDefinitionComposite.this.getShell(), Messages.getString("GridConnectionDefinitionComposite.conn_error"), Messages.getString("GridConnectionDefinitionComposite.invalid_temp_conn_error"), pExc);
                            GridConnectionDefinitionComposite.this.pathLink.setEnabled(true);
                        }
                    }
                    finally {
                        GridConnectionDefinitionComposite.this.pathLink.setEnabled(true);
                    }
                }
            }
        });
    }

    protected void resetFields() {
        this.setActive(this.uriCombo, this.uriLabel, Messages.getString("GridConnectionDefinitionComposite.uri_label"));
        this.setActive(this.schemeSpecificPartCombo, this.schemeSpecificPartLabel, null);
        this.setActive(this.authorityCombo, this.authorityLabel, null);
        this.setActive(this.userInfoCombo, this.userInfoLabel, null);
        this.setActive(this.hostCombo, this.hostLabel, null);
        this.setActive(this.portCombo, this.portLabel, null);
        this.setActive(this.pathCombo, this.pathLabel, null);
        this.setActive(this.queryCombo, this.queryLabel, null);
        this.setActive(this.fragmentCombo, this.fragmentLabel, null);
        String scheme = this.schemeCombo.getText();
        if (!this.isEmpty(scheme)) {
            this.uriCombo.setText(String.valueOf(scheme) + SEPARATOR);
        }
        this.currentURIType = "raw";
        this.validator = null;
    }

    protected void setupFields() {
        this.resetFields();
        String scheme = this.schemeCombo.getText();
        IConfigurationElement extension = Extensions.getRegisteredEFSExtension(scheme);
        if (extension != null) {
            IConfigurationElement[] children = extension.getChildren();
            if (children != null && children.length == 1) {
                this.setActive(this.uriCombo, this.uriLabel, null);
                this.processURIScheme(children[0]);
            }
            try {
                this.validator = (IConnectionTokenValidator)extension.createExecutableExtension("validator");
            }
            catch (CoreException coreException) {}
            try {
                this.processor = (IConnectionUriProcessor)extension.createExecutableExtension("processor");
            }
            catch (CoreException coreException) {}
        }
        this.layout();
        this.updateUI();
    }

    protected void updateUI() {
        URI uri = this.getURI();
        this.viewer.getTree().setEnabled(uri != null);
        this.pathLink.setEnabled(uri != null);
        this.fireModifyEvent();
    }

    private StoredCombo createEditorField(Composite parent, Label label, String text, ModifyListener listener) {
        label.setText(String.valueOf(text) + SEPARATOR);
        GridData lData = new GridData();
        lData.minimumHeight = 0;
        label.setLayoutData((Object)lData);
        StoredCombo editor = new StoredCombo(parent, 0);
        GridData eData = new GridData(768);
        eData.grabExcessHorizontalSpace = true;
        eData.minimumHeight = 0;
        editor.setLayoutData(eData);
        editor.addModifyListener(listener);
        return editor;
    }

    private void initializeSchemeCombo(Combo combo) {
        combo.removeAll();
        List schemes = eu.geclipse.core.Extensions.getRegisteredFilesystemSchemes();
        Collections.sort(schemes, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        for (String scheme : schemes) {
            if (scheme.equalsIgnoreCase(FS_GECL) || scheme.equalsIgnoreCase(FS_NULL)) continue;
            combo.add(scheme);
        }
    }

    private boolean isActive(StoredCombo editor) {
        boolean result = false;
        Boolean active = (Boolean)editor.getData(KEY_FIELD_ACTIVE);
        if (active != null) {
            result = active;
        }
        return result;
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void processURIScheme(IConfigurationElement element) {
        this.currentURIType = element.getName();
        if (this.currentURIType.equals("raw")) {
            this.processRawURIScheme(element);
        } else if (this.currentURIType.equals("opaque")) {
            this.processOpaqueURIScheme(element);
        } else if (this.currentURIType.equals("hierarchical")) {
            this.processHierarchicalURIScheme(element);
        } else if (this.currentURIType.equals("server")) {
            this.processServerURIScheme(element);
        }
    }

    private void processServerURIScheme(IConfigurationElement element) {
        String userInfo = element.getAttribute("user-info");
        String host = element.getAttribute("host");
        String port = element.getAttribute("port");
        String path = element.getAttribute("path");
        String query = element.getAttribute("query");
        String fragment = element.getAttribute("fragment");
        this.setActive(this.userInfoCombo, this.userInfoLabel, userInfo);
        this.setActive(this.hostCombo, this.hostLabel, host);
        this.setActive(this.portCombo, this.portLabel, port);
        this.setActive(this.pathCombo, this.pathLabel, path);
        this.setActive(this.queryCombo, this.queryLabel, query);
        this.setActive(this.fragmentCombo, this.fragmentLabel, fragment);
        String scheme = this.schemeCombo.getText();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.userInfoCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "user-info");
        this.hostCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "host");
        this.portCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "port");
        this.pathCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "path");
        this.queryCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "query");
        this.fragmentCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "fragment");
    }

    private void processHierarchicalURIScheme(IConfigurationElement element) {
        String authority = element.getAttribute("authority");
        String path = element.getAttribute("path");
        String query = element.getAttribute("query");
        String fragment = element.getAttribute("fragment");
        this.setActive(this.authorityCombo, this.authorityLabel, authority);
        this.setActive(this.pathCombo, this.pathLabel, path);
        this.setActive(this.queryCombo, this.queryLabel, query);
        this.setActive(this.fragmentCombo, this.fragmentLabel, fragment);
        String scheme = this.schemeCombo.getText();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.authorityCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "authority");
        this.pathCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "path");
        this.queryCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "query");
        this.fragmentCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "fragment");
    }

    private void processOpaqueURIScheme(IConfigurationElement element) {
        String schemeSpecificPart = element.getAttribute("scheme-specific-part");
        String fragment = element.getAttribute("fragment");
        this.setActive(this.schemeSpecificPartCombo, this.schemeSpecificPartLabel, schemeSpecificPart);
        this.setActive(this.fragmentCombo, this.fragmentLabel, fragment);
        String scheme = this.schemeCombo.getText();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.schemeSpecificPartCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "scheme-specific-part");
        this.fragmentCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "fragment");
    }

    private void processRawURIScheme(IConfigurationElement element) {
        String uri = element.getAttribute("uri");
        this.setActive(this.uriCombo, this.uriLabel, uri);
        String scheme = this.schemeCombo.getText();
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        this.uriCombo.setPreferences(preferenceStore, String.valueOf(scheme) + SEPARATOR + "uri");
    }

    private void refreshViewer(final IGridElement element) {
        Control control = this.viewer.getControl();
        if (!control.isDisposed()) {
            Display display = control.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!GridConnectionDefinitionComposite.this.viewer.getControl().isDisposed()) {
                        if (element == null) {
                            GridConnectionDefinitionComposite.this.viewer.refresh(false);
                        } else {
                            IGridContainer container;
                            if (element instanceof IGridContainer && (container = (IGridContainer)element).isLazy() && container.isDirty()) {
                                GridConnectionDefinitionComposite.this.viewer.setChildCount((Object)container, container.getChildCount());
                            }
                            GridConnectionDefinitionComposite.this.viewer.refresh((Object)element, false);
                        }
                    }
                }
            });
        }
    }

    private void setActive(StoredCombo editor, Label label, String text) {
        if (!this.isEmpty(text)) {
            label.setText(String.valueOf(text) + SEPARATOR);
        }
        label.setVisible(!this.isEmpty(text));
        editor.setVisible(!this.isEmpty(text));
        editor.setData(KEY_FIELD_ACTIVE, !this.isEmpty(text));
        ((GridData)label.getLayoutData()).exclude = this.isEmpty(text);
        ((GridData)editor.getLayoutData()).exclude = this.isEmpty(text);
    }

    private static class EditorFieldModifyListener
    implements ModifyListener {
        private GridConnectionDefinitionComposite parent;
        private boolean active;

        public EditorFieldModifyListener(GridConnectionDefinitionComposite parent) {
            this.parent = parent;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean b) {
            this.active = b;
        }

        public void modifyText(ModifyEvent e) {
            if (this.isActive()) {
                this.parent.updateUI();
            }
        }
    }
}

