/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.providers.ArrayTableLabelProvider;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridProjectStructureComposite
extends Composite {
    private static final int LABEL_COLUMN = 1;
    protected TableEditor editor;
    private Tree previewTree;
    private TreeItem rootItem;
    private Table table;
    private CheckboxTableViewer viewer;
    private Hashtable<String, Class<?>> creatorTargets;
    private Hashtable<String, Class<?>> elementClasses;

    public GridProjectStructureComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        GridData gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        this.setLayoutData(gData);
        Composite previewComp = new Composite((Composite)this, 0);
        previewComp.setLayout((Layout)new GridLayout(1, false));
        gData = new GridData(1040);
        gData.grabExcessVerticalSpace = true;
        previewComp.setLayoutData((Object)gData);
        Label previewLabel = new Label(previewComp, 0);
        previewLabel.setText("Preview:");
        gData = new GridData();
        previewLabel.setLayoutData((Object)gData);
        this.previewTree = new Tree(previewComp, 2048);
        gData = new GridData(1040);
        gData.grabExcessVerticalSpace = true;
        gData.widthHint = 150;
        this.previewTree.setLayoutData((Object)gData);
        this.rootItem = new TreeItem(this.previewTree, 0);
        this.rootItem.setText("My Grid Project");
        this.rootItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
        Composite settingsComp = new Composite((Composite)this, 0);
        settingsComp.setLayout((Layout)new GridLayout(1, false));
        gData = new GridData(1808);
        gData.grabExcessVerticalSpace = true;
        gData.grabExcessHorizontalSpace = true;
        settingsComp.setLayoutData((Object)gData);
        Label settingsLabel = new Label(settingsComp, 0);
        settingsLabel.setText("Available Folders:");
        gData = new GridData();
        settingsLabel.setLayoutData((Object)gData);
        this.table = new Table(settingsComp, 68384);
        this.table.setHeaderVisible(true);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        this.table.setLayoutData((Object)gData);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setText("Folder ID");
        nameColumn.setWidth(150);
        TableColumn labelColumn = new TableColumn(this.table, 0);
        labelColumn.setText("Folder Label");
        labelColumn.setWidth(100);
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 100;
        this.editor.horizontalAlignment = 16384;
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridProjectStructureComposite.this.startEditing((TableItem)e.item);
            }
        });
        this.viewer = new CheckboxTableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ArrayTableLabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                GridProjectStructureComposite.this.updateTree();
            }
        });
        Composite buttonComp = new Composite(settingsComp, 0);
        GridLayout buttonLayout = new GridLayout(3, false);
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComp.setLayout((Layout)buttonLayout);
        buttonComp.setLayoutData((Object)new GridData(1, 1, false, false));
        Button selectAllButton = new Button(buttonComp, 0);
        selectAllButton.setText("Select All");
        selectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridProjectStructureComposite.this.selectAll();
            }
        });
        Button deselectAllButton = new Button(buttonComp, 0);
        deselectAllButton.setText("Deselect All");
        deselectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridProjectStructureComposite.this.deselectAll();
            }
        });
        Button invertButton = new Button(buttonComp, 0);
        invertButton.setText("Invert Selection");
        invertButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        invertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridProjectStructureComposite.this.invertSelection();
            }
        });
        this.loadProjectFolders();
        this.initialize();
        this.updateTree();
    }

    public Hashtable<String, String> getProjectFolders() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        List input = (List)this.viewer.getInput();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                String id = ((String[])input.get(i))[2];
                String label = items[i].getText(1);
                result.put(id, label);
            }
            ++i;
        }
        return result;
    }

    public void performDefaults() {
        this.loadProjectFolders();
        this.updateTree();
    }

    public void setProject(IProject project) throws CoreException {
        IResource[] members;
        Hashtable<String, String> projectFolders = new Hashtable<String, String>();
        IGridProject gridProject = (IGridProject)GridModel.getRoot().findElement((IResource)project);
        IResource[] iResourceArray = members = project.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IResource resource = iResourceArray[n2];
            String name = resource.getName();
            IGridElement element = gridProject.findChild(name);
            if (element != null && element instanceof IGridContainer && (id = gridProject.getProjectFolderID((IGridContainer)element)) != null) {
                projectFolders.put(id, name);
            }
            ++n2;
        }
        this.setProjectFolders(projectFolders);
    }

    public void setProjectFolders(Hashtable<String, String> projectFolders) {
        List input = (List)this.viewer.getInput();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < input.size()) {
            String id = ((String[])input.get(i))[2];
            String name = projectFolders.get(id);
            if (name != null) {
                items[i].setChecked(true);
                items[i].setText(1, name);
            } else {
                items[i].setChecked(false);
            }
            ++i;
        }
        this.updateTree();
    }

    protected void selectAll() {
        this.viewer.setAllChecked(true);
        this.updateTree();
    }

    protected void deselectAll() {
        this.viewer.setAllChecked(false);
        this.updateTree();
    }

    protected void invertSelection() {
        List elements = (List)this.viewer.getInput();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            String[] element;
            boolean state = this.viewer.getChecked((Object)(element = (String[])iterator.next()));
            this.viewer.setChecked((Object)element, !state);
        }
        this.updateTree();
    }

    protected void updateTree() {
        this.rootItem.removeAll();
        Object[] checked = this.viewer.getCheckedElements();
        TableItem[] data = this.table.getItems();
        TreeItem[] treeItems = new TreeItem[checked.length];
        int index = 0;
        TableItem[] tableItemArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem row = tableItemArray[n2];
            if (row.getChecked()) {
                treeItems[index] = new TreeItem(this.rootItem, 0);
                treeItems[index].setText(row.getText(1));
                treeItems[index].setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
                ++index;
            }
            ++n2;
        }
        for (String name : this.creatorTargets.keySet()) {
            Class<?> creatorTarget = this.creatorTargets.get(name);
            TreeItem parentItem = this.findParentForTarget(checked, treeItems, creatorTarget, true);
            if (parentItem == null) {
                parentItem = this.findParentForTarget(checked, treeItems, creatorTarget, false);
            }
            if (parentItem == null) {
                parentItem = this.rootItem;
            }
            TreeItem leafItem = new TreeItem(parentItem, 0);
            leafItem.setText(name);
            leafItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"));
        }
        this.rootItem.setExpanded(true);
        tableItemArray = this.rootItem.getItems();
        n = tableItemArray.length;
        int n3 = 0;
        while (n3 < n) {
            TableItem child = tableItemArray[n3];
            child.setExpanded(true);
            ++n3;
        }
    }

    private TreeItem findParentForTarget(Object[] checked, TreeItem[] treeItems, Class<?> creatorTarget, boolean equalClass) {
        TreeItem parentItem = null;
        int i = 0;
        while (i < checked.length && parentItem == null) {
            try {
                String elementClassName = ((String[])checked[i])[3];
                Class<?> elementClass = this.elementClasses.get(elementClassName);
                if (elementClass == null) {
                    elementClass = Class.forName(elementClassName);
                }
                if (equalClass) {
                    if (elementClass.equals(creatorTarget)) {
                        parentItem = treeItems[i];
                    }
                } else if (elementClass.isAssignableFrom(creatorTarget)) {
                    parentItem = treeItems[i];
                }
            }
            catch (ClassNotFoundException cnfExc) {
                Activator.logException(cnfExc);
            }
            ++i;
        }
        return parentItem;
    }

    private void initialize() {
        if (this.creatorTargets == null) {
            this.creatorTargets = new Hashtable();
            new ExtensionManager();
            List creators = GridModel.getCreatorRegistry().getConfigurations();
            for (IConfigurationElement creator : creators) {
                IConfigurationElement[] targets = creator.getChildren("target");
                if (targets == null) continue;
                IConfigurationElement[] iConfigurationElementArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement target = iConfigurationElementArray[n2];
                    String name = target.getAttribute("name");
                    String className = target.getAttribute("class");
                    String contributor = target.getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)contributor);
                    if (bundle != null) {
                        try {
                            Class cls = bundle.loadClass(className);
                            if (!IGridResource.class.isAssignableFrom(cls) && !IVirtualOrganization.class.isAssignableFrom(cls)) {
                                this.creatorTargets.put(name, cls);
                            }
                        }
                        catch (ClassNotFoundException cnfExc) {
                            Activator.logException(cnfExc);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private void loadProjectFolders() {
        if (this.elementClasses == null) {
            this.elementClasses = new Hashtable();
        }
        ArrayList<String[]> input = new ArrayList<String[]>();
        ArrayList<String[]> checked = new ArrayList<String[]>();
        ExtensionManager extm = new ExtensionManager();
        List configurationElements = extm.getConfigurationElements("eu.geclipse.core.gridProjectFolder", "folder");
        for (IConfigurationElement element : configurationElements) {
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            String label = element.getAttribute("label");
            String cls = element.getAttribute("elementClass");
            try {
                String contributor = element.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributor);
                Class elementClass = bundle.loadClass(cls);
                this.elementClasses.put(cls, elementClass);
            }
            catch (ClassNotFoundException exception) {
                Activator.logException(exception);
            }
            boolean preset = Boolean.parseBoolean(element.getAttribute("preset"));
            String[] row = new String[]{name, label, id, cls};
            input.add(row);
            if (!preset) continue;
            checked.add(row);
        }
        this.viewer.setInput(input);
        this.viewer.setCheckedElements(checked.toArray());
    }

    private void startEditing(TableItem item) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (item != null) {
            Text text = new Text((Composite)this.table, 0);
            text.setText(item.getText(1));
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)GridProjectStructureComposite.this.editor.getEditor();
                    GridProjectStructureComposite.this.editor.getItem().setText(1, t.getText());
                    GridProjectStructureComposite.this.updateTree();
                }
            });
            text.selectAll();
            text.setFocus();
            this.editor.setEditor((Control)text, item, 1);
        }
    }
}

