/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.widgets;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class StoredCombo
extends Combo {
    private static final String prefSeparator = "\u001e";
    private static String LAST_ITEM_PREFIX = "_last";
    protected boolean allowCompletion = true;
    private IPreferenceStore prefStore = null;
    private String prefID;

    public StoredCombo(Composite parent, int style) {
        super(parent, style);
        this.addModifyListener(new ModifyListener(){
            private boolean alreadyModifing = false;

            public void modifyText(ModifyEvent event) {
                if (!this.alreadyModifing && StoredCombo.this.allowCompletion) {
                    this.alreadyModifing = true;
                    StoredCombo.this.doAutoCompletion();
                    this.alreadyModifing = false;
                }
            }
        });
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                StoredCombo.this.allowCompletion = false;
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                switch (event.character) {
                    case '\b': 
                    case '\u007f': {
                        StoredCombo.this.allowCompletion = false;
                        break;
                    }
                    default: {
                        StoredCombo.this.allowCompletion = true;
                    }
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                Combo combo = (Combo)event.widget;
                String text = combo.getText();
                combo.setSelection(new Point(text.length(), text.length()));
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StoredCombo.this.savePreferences();
            }
        });
    }

    public void setPreferences(IPreferenceStore preferenceStore, String preferenceID) {
        this.removeAll();
        this.prefStore = preferenceStore;
        this.prefID = preferenceID;
        if (this.prefStore != null) {
            String[] items;
            String itemList = this.prefStore.getString(this.prefID);
            String[] stringArray = items = itemList.split(prefSeparator);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.trim().length() > 0 && this.isValidItem(item)) {
                    this.add(item);
                }
                ++n2;
            }
            String lastItem = this.prefStore.getString(String.valueOf(this.prefID) + LAST_ITEM_PREFIX);
            if (this.isValidItem(lastItem)) {
                boolean save = this.allowCompletion;
                this.allowCompletion = false;
                this.setText(lastItem);
                this.allowCompletion = save;
            }
        }
    }

    public boolean setDefaultItem(String defaultItem) {
        boolean valid = this.isValidItem(defaultItem);
        if (valid) {
            boolean save = this.allowCompletion;
            this.allowCompletion = false;
            this.setText(defaultItem);
            this.allowCompletion = save;
        }
        return valid;
    }

    public void addUnique(String newEntry) {
        if (this.indexOf(newEntry) == -1) {
            this.add(newEntry);
        }
    }

    public void purgeAll() {
        this.removeAll();
        this.savePreferences();
    }

    protected void doAutoCompletion() {
        String text = this.getText();
        if (text.length() > 0) {
            String[] items;
            String newText = null;
            String[] stringArray = items = this.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.startsWith(text) && (newText == null || item.length() < newText.length())) {
                    newText = item;
                }
                ++n2;
            }
            if (newText != null) {
                this.setText(newText);
                this.setSelection(new Point(text.length(), newText.length()));
            }
        }
    }

    protected void savePreferences() {
        if (this.prefStore != null) {
            String[] items;
            String cText = this.getText();
            this.prefStore.setValue(String.valueOf(this.prefID) + LAST_ITEM_PREFIX, cText);
            ArrayList<String> itemList = new ArrayList<String>();
            if (cText.length() > 0 && this.isValidItem(cText)) {
                itemList.add(cText);
            }
            String[] stringArray = items = this.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (this.isValidItem(item) && !itemList.contains(item)) {
                    itemList.add(item);
                }
                ++n2;
            }
            StringBuilder buffer = new StringBuilder();
            for (String item : itemList) {
                buffer.append(String.valueOf(item) + prefSeparator);
            }
            if (buffer.length() > 0) {
                String s = buffer.substring(0, buffer.length() - 1);
                this.prefStore.setValue(this.prefID, s);
            } else {
                this.prefStore.setToDefault(this.prefID);
            }
        }
    }

    protected boolean isValidItem(String item) {
        return true;
    }

    protected void checkSubclass() {
    }
}

