/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.ui.wizards.IConnectionTokenValidator;
import eu.geclipse.ui.wizards.Messages;

public class GenericConnectionTokenValidator
implements IConnectionTokenValidator {
    public String validateToken(String tokenID, String tokenValue) {
        String error = null;
        if ("uri".equals(tokenID)) {
            error = this.validateURI(tokenValue);
        } else if ("scheme-specific-part".equals(tokenID)) {
            error = this.validateSchemeSpecificPart(tokenValue);
        } else if ("authority".equals(tokenID)) {
            error = this.validateAuthority(tokenValue);
        } else if ("user-info".equals(tokenID)) {
            error = this.validateUserInfo(tokenValue);
        } else if ("host".equals(tokenID)) {
            error = this.validateHost(tokenValue);
        } else if ("port".equals(tokenID)) {
            error = this.validatePort(tokenValue);
        } else if ("path".equals(tokenID)) {
            error = this.validatePath(tokenValue);
        } else if ("query".equals(tokenID)) {
            error = this.validateQuery(tokenValue);
        } else if ("fragment".equals(tokenID)) {
            error = this.validateFragment(tokenValue);
        }
        return error;
    }

    protected String validateURI(String uri) {
        return null;
    }

    protected String validateSchemeSpecificPart(String schemeSpecificPart) {
        return null;
    }

    protected String validateAuthority(String authority) {
        return null;
    }

    protected String validateUserInfo(String userInfo) {
        return null;
    }

    protected String validateHost(String host) {
        String error = null;
        if (!host.matches("[a-zA-Z0-9-_.]+") || host.startsWith(".") || host.endsWith(".")) {
            error = Messages.getString("GenericConnectionTokenValidator.hostname");
        }
        return error;
    }

    protected String validatePort(String port) {
        String error = null;
        try {
            int portnr = Integer.parseInt(port);
            error = this.validatePort(portnr);
        }
        catch (NumberFormatException numberFormatException) {
            error = Messages.getString("GenericConnectionTokenValidator.port_nan");
        }
        return error;
    }

    protected String validatePort(int port) {
        String error = null;
        if (port < 1 || port > 65535) {
            error = Messages.getString("GenericConnectionTokenValidator.port_invalid_range");
        }
        return error;
    }

    protected String validatePath(String path) {
        return null;
    }

    protected String validateQuery(String query) {
        return null;
    }

    protected String validateFragment(String fragment) {
        return null;
    }
}

