/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.GridProjectCreationOperation;
import eu.geclipse.ui.wizards.GridProjectProperties;
import eu.geclipse.ui.wizards.GridProjectStructureWizardPage;
import eu.geclipse.ui.wizards.Messages;
import eu.geclipse.ui.wizards.VoSelectionWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;

public class NewGridProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage creationPage;
    private VoSelectionWizardPage voPage;
    private GridProjectStructureWizardPage structurePage;
    private WizardNewProjectReferencePage referencePage;
    private IProject project = null;

    public boolean performFinish() {
        IProject proj = this.createNewProject();
        if (proj != null) {
            this.switchPerspective();
        }
        return proj != null;
    }

    private void switchPerspective() {
        final IWorkbench workBench = Activator.getDefault().getWorkbench();
        Display display = workBench.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = null;
                IWorkbenchWindow window = workBench.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
                    String newPerspectiveId = ps.getString("DefaultPerspective");
                    if (newPerspectiveId == null) {
                        return;
                    }
                    IPerspectiveDescriptor perspectiveDescriptor = page.getPerspective();
                    if (perspectiveDescriptor != null && !perspectiveDescriptor.getId().equals(newPerspectiveId)) {
                        if ((perspectiveDescriptor.getId().equals("eu.geclipse.ui.userPerspective") || perspectiveDescriptor.getId().equals("eu.geclipse.ui.operatorPerspective") || perspectiveDescriptor.getId().equals("eu.geclipse.ui.developerPerspective")) && ps.getBoolean("NotSwitchFromGEclipsePerspectives")) {
                            return;
                        }
                        try {
                            String newLine = System.getProperty("line.separator");
                            String message = Messages.getString("NewGridProjectWizard.PerspectiveSwitchingInfo_line1");
                            message = String.valueOf(message) + newLine + newLine;
                            message = String.valueOf(message) + Messages.getString("NewGridProjectWizard.PerspectiveSwitchingInfo_line2");
                            message = String.valueOf(message) + newLine + newLine;
                            message = String.valueOf(message) + Messages.getString("NewGridProjectWizard.PerspectiveSwitchingInfo_line3");
                            String toggleMessage = Messages.getString("NewGridProjectWizard.RememberQuestion");
                            String ask = ps.getString("RememberSwitchingPerspective");
                            if ("never".equalsIgnoreCase(ask)) {
                                return;
                            }
                            if ("always".equalsIgnoreCase(ask) || MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)Messages.getString("NewGridProjectWizard.ConfirmPerpectiveSwitch"), (String)message, (String)toggleMessage, (boolean)false, (IPreferenceStore)ps, (String)"RememberSwitchingPerspective").getReturnCode() == 2) {
                                String pId = ps.getString("DefaultPerspective");
                                window.getWorkbench().showPerspective(pId, window);
                            }
                        }
                        catch (Exception e) {
                            Status status = new Status(4, "eu.geclipse.ui", Messages.getString("NewGridProjectWizard.PerspectiveSwitchingError"), (Throwable)e);
                            ErrorDialog.openError((Shell)window.getShell(), (String)Messages.getString("NewGridProjectWizard.PerspectiveSwitchingError"), (String)Messages.getString("NewGridProjectWizard.ManualPerspectiveSwitching"), (IStatus)status);
                        }
                    }
                }
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.getString("NewGridProjectWizard.windowTitle"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/newgridprj_wiz.gif");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public void addPages() {
        this.creationPage = new WizardNewProjectCreationPage("newGridProjectBasicPage");
        this.creationPage.setTitle(Messages.getString("NewGridProjectWizard.basic_page_title"));
        this.creationPage.setDescription(Messages.getString("NewGridProjectWizard.basic_page_description"));
        this.addPage((IWizardPage)this.creationPage);
        this.voPage = new VoSelectionWizardPage(false);
        this.addPage((IWizardPage)this.voPage);
        this.structurePage = new GridProjectStructureWizardPage();
        this.addPage((IWizardPage)this.structurePage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("newGridProjectReferencePage");
            this.referencePage.setTitle(Messages.getString("NewGridProjectWizard.reference_page_title"));
            this.referencePage.setDescription(Messages.getString("NewGridProjectWizard.reference_page_description"));
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage != this.creationPage) {
            result = super.canFinish();
        }
        return result;
    }

    private IProject createNewProject() {
        if (this.project == null && this.creationPage != null) {
            GridProjectProperties properties = new GridProjectProperties();
            properties.setProjectName(this.creationPage.getProjectName());
            properties.setProjectLocation(this.creationPage.useDefaults() ? null : this.creationPage.getLocationPath());
            properties.setProjectVo(this.voPage.getSelectedVos()[0]);
            properties.addProjectFolders(this.structurePage.getProjectFolders());
            if (this.referencePage != null) {
                properties.setReferencesProjects(this.referencePage.getReferencedProjects());
            }
            GridProjectCreationOperation creationOp = new GridProjectCreationOperation(properties);
            WorkspaceModifyDelegatingOperation modifyOp = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)creationOp);
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)modifyOp);
                this.project = creationOp.getProject();
            }
            catch (InterruptedException intExc) {
                Activator.logException(intExc);
            }
            catch (InvocationTargetException itExc) {
                Activator.logException(itExc);
            }
        }
        return this.project;
    }
}

