/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.jobsubmission;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.core.model.IGridJobCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridJobID;
import eu.geclipse.core.model.IGridJobService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.wizards.jobsubmission.Messages;
import eu.geclipse.ui.wizards.jobsubmission.WrapperInitObject;
import eu.geclipse.ui.wizards.wizardselection.IInitializableWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public abstract class JobSubmissionWizardBase
extends Wizard
implements IInitializableWizard,
IExecutableExtension {
    protected IGridJobCreator creator;
    protected List<IGridJobDescription> jobDescriptions;
    ArrayList<String> jobNames;
    WrapperInitObject initObject;

    protected JobSubmissionWizardBase() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        JobSubmissionJob job = new JobSubmissionJob();
        job.setUser(true);
        Shell shell = this.getWizardShell();
        if (shell != null) {
            shell.setVisible(false);
        }
        job.schedule();
        return false;
    }

    protected abstract IGridJobService getSubmissionService();

    IGridContainer buildPath(IGridJobDescription description) throws CoreException {
        IGridProject result = null;
        IGridProject project = description.getProject();
        IPath projectPath = project.getPath();
        IGridContainer jobFolder = project.getProjectFolder(IGridJob.class);
        IPath jobFolderPath = jobFolder.getPath();
        if (jobFolderPath.equals((Object)projectPath)) {
            result = project;
        } else {
            IPath descriptionPath = description.getPath().removeLastSegments(1);
            IGridContainer descriptionFolder = project.getProjectFolder(IGridJobDescription.class);
            IPath descriptionFolderPath = descriptionFolder.getPath();
            if (descriptionFolderPath.isPrefixOf(descriptionPath)) {
                int matchingFirstSegments = descriptionPath.matchingFirstSegments(descriptionFolderPath);
                IPath appendedPath = descriptionPath.removeFirstSegments(matchingFirstSegments);
                jobFolderPath = jobFolderPath.append(appendedPath);
                IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
                IFolder folder = workspaceRoot.getFolder(jobFolderPath);
                this.createFolder((IContainer)folder);
                result = (IGridContainer)GridModel.getRoot().findElement((IResource)folder);
            } else {
                result = jobFolder;
            }
        }
        return result;
    }

    void createFolder(IContainer folder) throws CoreException {
        IContainer parent = folder.getParent();
        if (parent != null && parent instanceof IFolder) {
            this.createFolder(parent);
        }
        if (!folder.exists() && folder instanceof IFolder) {
            ((IFolder)folder).create(true, true, null);
        }
    }

    public boolean init(Object data) {
        boolean result = false;
        if (data instanceof WrapperInitObject) {
            this.initObject = (WrapperInitObject)data;
            this.jobDescriptions = new ArrayList<IGridJobDescription>(this.initObject.getJobDescriptions());
            this.jobNames = new ArrayList<String>(this.initObject.getJobNames());
            result = true;
        }
        return result;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = config.getDeclaringExtension().getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("job_creator".equals(element.getName())) {
                Object obj = element.createExecutableExtension("class");
                if (!(obj instanceof IGridJobCreator)) {
                    String errorMessage = "Job Creator configured in class atribute for job_creator element in eu.geclipse.ou.jobSubmissionWizzard is not implementing IGridJobCreator interface";
                    Status status = new Status(4, "eu.geclipse.ui", 0, errorMessage, null);
                    throw new CoreException((IStatus)status);
                }
                this.creator = (IGridJobCreator)obj;
            }
            ++n2;
        }
    }

    private Shell getWizardShell() {
        Shell shell = null;
        if (this.getContainer() != null) {
            shell = this.getContainer().getShell();
        }
        return shell;
    }

    protected void addShowWizardSolution(Throwable exc) {
        if (exc instanceof ProblemException) {
            ProblemException problemExc = (ProblemException)exc;
            IProblem problem = problemExc.getProblem();
            problem.addSolution(new ISolution(){

                public String getDescription() {
                    return Messages.getString("JobSubmissionWizardBase.solutionOpenWizard");
                }

                public String getID() {
                    return null;
                }

                public boolean isActive() {
                    return true;
                }

                public void solve() throws InvocationTargetException {
                    JobSubmissionWizardBase.this.getContainer().getShell().setVisible(true);
                }
            });
        }
    }

    private class JobSubmissionJob
    extends Job {
        final IGridJobService service;

        JobSubmissionJob() {
            super(Messages.getString("JobSubmissionWizardBase.jobName"));
            this.service = JobSubmissionWizardBase.this.getSubmissionService();
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean closeWizard;
            block10: {
                closeWizard = true;
                SubMonitor betterMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)JobSubmissionWizardBase.this.jobDescriptions.size());
                try {
                    Iterator<IGridJobDescription> iterator = JobSubmissionWizardBase.this.jobDescriptions.iterator();
                    Iterator<String> namesIterator = JobSubmissionWizardBase.this.jobNames.iterator();
                    while (iterator.hasNext()) {
                        this.testCancelled((IProgressMonitor)betterMonitor);
                        IGridJobDescription description = iterator.next();
                        betterMonitor.setTaskName(String.format(Messages.getString("JobSubmissionWizardBase.taskNameSubmitting"), description.getName()));
                        if (!JobSubmissionWizardBase.this.creator.canCreate(description)) continue;
                        IGridContainer parent = this.buildTargetFolder(description, JobSubmissionWizardBase.this.initObject.getDestinationFolder());
                        IGridJobID jobId = null;
                        if (this.service != null) {
                            jobId = this.service.submitJob(description, (IProgressMonitor)betterMonitor.newChild(1));
                        }
                        this.testCancelled((IProgressMonitor)betterMonitor);
                        JobSubmissionWizardBase.this.creator.create(parent, jobId, this.service, namesIterator.next());
                        iterator.remove();
                        namesIterator.remove();
                    }
                }
                catch (ProblemException pExc) {
                    this.showProblem(pExc);
                    closeWizard = false;
                    betterMonitor.done();
                    break block10;
                }
                catch (CoreException cExc) {
                    try {
                        this.showProblem(cExc);
                        closeWizard = false;
                        break block10;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        betterMonitor.done();
                    }
                }
                betterMonitor.done();
            }
            if (closeWizard) {
                this.closeWizard();
            }
            return Status.OK_STATUS;
        }

        private IGridContainer buildTargetFolder(IGridJobDescription description, IResource folder) throws CoreException {
            IResource targetFolder = folder;
            Object targetBuildFolder = null;
            IGridProject project = description.getProject();
            IPath descriptionPath = description.getPath().removeLastSegments(1);
            IPath descriptionFolderPath = project.getProjectFolder(IGridJobDescription.class).getPath();
            if (descriptionFolderPath.isPrefixOf(descriptionPath) && folder.getFullPath().equals((Object)project.getProjectFolder(IGridJob.class).getPath())) {
                int matchingFirstSegments = descriptionPath.matchingFirstSegments(descriptionFolderPath);
                IPath appendedPath = descriptionPath.removeFirstSegments(matchingFirstSegments);
                IWorkspaceRoot workspaceRoot = (IWorkspaceRoot)GridModel.getRoot().getResource();
                targetBuildFolder = targetFolder instanceof IProject && appendedPath.toString().equals("") ? (IContainer)targetFolder : workspaceRoot.getFolder(targetFolder.getFullPath().append(appendedPath));
                JobSubmissionWizardBase.this.createFolder((IContainer)targetBuildFolder);
            }
            if (targetBuildFolder == null) {
                targetBuildFolder = (IContainer)targetFolder;
            }
            return (IGridContainer)GridModel.getRoot().findElement((IResource)targetBuildFolder);
        }

        private void testCancelled(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        void closeWizard() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    WizardDialog dialog = (WizardDialog)JobSubmissionWizardBase.this.getContainer();
                    dialog.close();
                }
            });
        }

        private void showProblem(final Throwable exc) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    JobSubmissionWizardBase.this.addShowWizardSolution(exc);
                    ProblemDialog.openProblem(JobSubmissionWizardBase.this.getShell(), Messages.getString("JobSubmissionWizardBase.errSubmissionFailed"), null, exc);
                    if (!JobSubmissionWizardBase.this.getContainer().getShell().isVisible()) {
                        JobSubmissionWizardBase.this.getContainer().getShell().close();
                    }
                }
            });
        }
    }
}

