/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.portforward;

import eu.geclipse.core.portforward.ForwardType;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.NumberVerifier;
import eu.geclipse.ui.widgets.StoredCombo;
import eu.geclipse.ui.wizards.portforward.ForwardTableEntry;
import eu.geclipse.ui.wizards.portforward.IForwardTableEntry;
import eu.geclipse.ui.wizards.portforward.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class NewPortForwardComposite
extends Composite {
    private static final String HOSTNAMES = "hostnames";
    private Label typeLabel = null;
    private Combo typeCombo = null;
    private Label bindPortLabel = null;
    private Label hostnameLabel = null;
    private Label portLabel = null;
    private Text bindPortText = null;
    private StoredCombo hostnameCombo = null;
    private Text portText = null;

    NewPortForwardComposite(Composite parent, int style, Listener listener) {
        super(parent, style);
        this.initialize();
        this.typeCombo.add(Messages.getString("NewPortForwardComposite.local"));
        this.typeCombo.add(Messages.getString("NewPortForwardComposite.remote"));
        this.typeCombo.select(0);
        Activator activator = Activator.getDefault();
        IPreferenceStore preferenceStore = activator.getPreferenceStore();
        this.hostnameCombo.setPreferences(preferenceStore, HOSTNAMES);
        NumberVerifier numberVerifier = new NumberVerifier();
        this.bindPortText.addListener(24, listener);
        this.hostnameCombo.addListener(24, listener);
        this.portText.addListener(24, listener);
        this.bindPortText.addListener(25, (Listener)numberVerifier);
        this.portText.addListener(25, (Listener)numberVerifier);
    }

    private void initialize() {
        GridData portTextGridData = new GridData();
        portTextGridData.horizontalAlignment = 4;
        portTextGridData.grabExcessHorizontalSpace = true;
        portTextGridData.verticalAlignment = 2;
        GridData hostnameComboGridData = new GridData();
        hostnameComboGridData.horizontalAlignment = 4;
        hostnameComboGridData.grabExcessHorizontalSpace = true;
        hostnameComboGridData.verticalAlignment = 2;
        GridData bindPortTextGridData = new GridData();
        bindPortTextGridData.horizontalAlignment = 4;
        bindPortTextGridData.grabExcessHorizontalSpace = true;
        bindPortTextGridData.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.typeLabel = new Label((Composite)this, 0);
        this.typeLabel.setText(Messages.getString("NewPortForwardComposite.type"));
        this.setLayout((Layout)gridLayout);
        this.createCombo();
        this.setSize(new Point(393, 217));
        this.bindPortLabel = new Label((Composite)this, 0);
        this.bindPortLabel.setText(Messages.getString("NewPortForwardComposite.bindPort"));
        this.bindPortText = new Text((Composite)this, 2048);
        this.bindPortText.setTextLimit(5);
        this.bindPortText.setLayoutData((Object)bindPortTextGridData);
        this.hostnameLabel = new Label((Composite)this, 0);
        this.hostnameLabel.setText(Messages.getString("NewPortForwardComposite.hostname"));
        this.hostnameCombo = new StoredCombo(this, 2048);
        this.hostnameCombo.setLayoutData(hostnameComboGridData);
        this.portLabel = new Label((Composite)this, 0);
        this.portLabel.setText(Messages.getString("NewPortForwardComposite.port"));
        this.portText = new Text((Composite)this, 2048);
        this.portText.setTextLimit(5);
        this.portText.setLayoutData((Object)portTextGridData);
    }

    private void createCombo() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.typeCombo = new Combo((Composite)this, 8);
        this.typeCombo.setLayoutData((Object)gridData);
    }

    IStatus getStatus() {
        Integer port = null;
        Integer bindPort = null;
        boolean validPort = true;
        boolean nonRootPort = true;
        try {
            port = new Integer(this.portText.getText());
            bindPort = new Integer(this.bindPortText.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        if (port == null || port < 1 || port > 65535 || bindPort == null || bindPort < 1 || bindPort > 65535) {
            validPort = false;
        } else if (bindPort < 1024) {
            nonRootPort = false;
        }
        Status status = new Status(0, "eu.geclipse.ui", 0, "", null);
        if (this.bindPortText.getText().length() == 0) {
            status = new Status(4, "eu.geclipse.ui", 0, Messages.getString("NewPortForwardComposite.bindPortMustNotBeEmpty"), null);
        } else if (this.hostnameCombo.getText().length() == 0) {
            status = new Status(4, "eu.geclipse.ui", 0, Messages.getString("NewPortForwardComposite.hostnameMustNotBeEmpty"), null);
        } else if (this.portText.getText().length() == 0) {
            status = new Status(4, "eu.geclipse.ui", 0, Messages.getString("NewPortForwardComposite.portMustNotBeEmpty"), null);
        } else if (!validPort) {
            status = new Status(4, "eu.geclipse.ui", 0, Messages.getString("NewPortForwardComposite.PortsMustBeInValidRange"), null);
        } else if (!nonRootPort) {
            status = new Status(2, "eu.geclipse.ui", 0, Messages.getString("NewPortForwardComposite.portsBelow1024"), null);
        }
        return status;
    }

    IForwardTableEntry getForward() {
        ForwardType type = this.typeCombo.getSelectionIndex() == 0 ? ForwardType.LOCAL : ForwardType.REMOTE;
        ForwardTableEntry forward = new ForwardTableEntry(type, new Integer(this.bindPortText.getText()), this.hostnameCombo.getText(), new Integer(this.portText.getText()), true);
        return forward;
    }
}

