/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.portforward;

import eu.geclipse.ui.wizards.portforward.IForwardTableEntry;
import eu.geclipse.ui.wizards.portforward.Messages;
import eu.geclipse.ui.wizards.portforward.NewPortForwardComposite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class NewPortForwardDialog
extends TitleAreaDialog
implements Listener {
    private NewPortForwardComposite composite;
    private IForwardTableEntry forward;

    protected NewPortForwardDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.getString("NewPortForwardDialog.title"));
        this.getShell().setText(Messages.getString("NewPortForwardDialog.title"));
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new NewPortForwardComposite(parent, 0, this);
        this.composite.setLayoutData(new GridData(1808));
        return this.composite;
    }

    public void handleEvent(Event event) {
        this.validateInput();
    }

    private void validateInput() {
        IStatus status = this.composite.getStatus();
        this.applyToStatusLine(status);
        this.getButton(0).setEnabled(status.getSeverity() != 4);
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    protected void okPressed() {
        this.forward = this.composite.getForward();
        super.okPressed();
    }

    IForwardTableEntry getForward() {
        return this.forward;
    }
}

