/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.portforward;

import eu.geclipse.core.portforward.IForward;
import eu.geclipse.ui.wizards.portforward.IForwardTableEntry;
import eu.geclipse.ui.wizards.portforward.Messages;
import eu.geclipse.ui.wizards.portforward.NewPortForwardDialog;
import eu.geclipse.ui.wizards.portforward.PortForwardingTableLabelProvider;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortForwardingOptionsComposite
extends Composite {
    Button removeButton = null;
    Table table = null;
    TableViewer tableViewer = null;
    private Button addButton = null;

    PortForwardingOptionsComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PortForwardingTableLabelProvider());
    }

    private void initialize() {
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.horizontalAlignment = 4;
        removeButtonGridData.verticalAlignment = 2;
        GridData addButtonGridData = new GridData();
        addButtonGridData.horizontalAlignment = 4;
        addButtonGridData.verticalAlignment = 2;
        GridData tableGridData = new GridData();
        tableGridData.verticalSpan = 3;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        tableGridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.table = new Table((Composite)this, 2050);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)tableGridData);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PortForwardingOptionsComposite.this.updateRemoveButtonStatus();
            }
        });
        TableColumn typeColumn = new TableColumn(this.table, 0);
        typeColumn.setWidth(100);
        typeColumn.setText(Messages.getString("PortForwardingOptionsComposite.type"));
        TableColumn bindPortColumn = new TableColumn(this.table, 0);
        bindPortColumn.setWidth(100);
        bindPortColumn.setText(Messages.getString("PortForwardingOptionsComposite.bindPort"));
        TableColumn hostColumn = new TableColumn(this.table, 0);
        hostColumn.setWidth(150);
        hostColumn.setText(Messages.getString("PortForwardingOptionsComposite.hostname"));
        TableColumn portColumn = new TableColumn(this.table, 0);
        portColumn.setWidth(100);
        portColumn.setText(Messages.getString("PortForwardingOptionsComposite.port"));
        this.addButton = new Button((Composite)this, 0);
        this.addButton.setText(Messages.getString("PortForwardingOptionsComposite.add"));
        this.addButton.setLayoutData((Object)addButtonGridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewPortForwardDialog dialog = new NewPortForwardDialog(PortForwardingOptionsComposite.this.getShell());
                if (dialog.open() == 0) {
                    IForwardTableEntry forward = dialog.getForward();
                    PortForwardingOptionsComposite.this.tableViewer.insert((Object)forward, -1);
                }
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText(Messages.getString("PortForwardingOptionsComposite.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)removeButtonGridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PortForwardingOptionsComposite.this.tableViewer.remove(PortForwardingOptionsComposite.this.tableViewer.getElementAt(PortForwardingOptionsComposite.this.table.getSelectionIndices()[0]));
                PortForwardingOptionsComposite.this.updateRemoveButtonStatus();
            }
        });
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(552, 296));
    }

    List<IForward> getForwards() {
        LinkedList<IForward> list = new LinkedList<IForward>();
        int i = 0;
        while (i < this.table.getItemCount()) {
            list.add((IForward)this.table.getItem(i).getData());
            ++i;
        }
        return list;
    }

    void updateRemoveButtonStatus() {
        boolean enabled;
        boolean bl = enabled = this.table.getSelectionCount() > 0;
        if (enabled) {
            IForwardTableEntry entry = (IForwardTableEntry)this.table.getItem(this.table.getSelectionIndex()).getData();
            enabled = entry.isRemoveable();
        }
        this.removeButton.setEnabled(enabled);
    }
}

