/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.wizards.wizardselection;

import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionNode;
import eu.geclipse.ui.wizards.wizardselection.IWizardSelectionNode;
import eu.geclipse.ui.wizards.wizardselection.WizardSelectionListPage;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtPointWizardSelectionListPage
extends WizardSelectionListPage {
    static final String EXT_CLASS = "class";
    static final String EXT_WIZARD = "wizard";
    static final String EXT_NAME = "name";
    static final String EXT_ICON = "icon";
    static final String EXT_ID = "id";
    static final String EXT_CAN_REPLACE = "canReplace";

    public ExtPointWizardSelectionListPage(String pageName, String extensionPointId, String title, String desc, String emptyListErrMsg) {
        super(pageName, ExtPointWizardSelectionListPage.getWizardList(extensionPointId, null, false), title, desc, emptyListErrMsg);
    }

    public ExtPointWizardSelectionListPage(String pageName, String extensionPointId, String title, String desc, String emptyListErrMsg, boolean quickSelection) {
        super(pageName, ExtPointWizardSelectionListPage.getWizardList(extensionPointId, null, false), title, desc, emptyListErrMsg, quickSelection);
    }

    public ExtPointWizardSelectionListPage(String pageName, String extensionPointId, List<String> filterList, boolean forceWizardIds, String title, String desc, String emptyListErrMsg) {
        super(pageName, ExtPointWizardSelectionListPage.getWizardList(extensionPointId, filterList, forceWizardIds), title, desc, emptyListErrMsg);
    }

    public void setPreselectedId(String id, boolean hidePrevPage) {
        if (id != null) {
            IWizardSelectionNode[] iWizardSelectionNodeArray = this.wizardSelectionNodes;
            int n = this.wizardSelectionNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardSelectionNode node = iWizardSelectionNodeArray[n2];
                ExtPointWizardSelectionNode extPointNode = (ExtPointWizardSelectionNode)node;
                if (id.equals(extPointNode.getId())) {
                    this.setPreselectedNode(extPointNode, hidePrevPage);
                }
                ++n2;
            }
        }
    }

    private static IWizardSelectionNode[] getWizardList(String extensionPointId, List<String> filterList, boolean forceWizardIds) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        Vector<IWizardSelectionNode> nodes = new Vector<IWizardSelectionNode>();
        if (extensionPoint != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (EXT_WIZARD.equals(element.getName())) {
                        String id = element.getAttribute(EXT_ID);
                        if (filterList == null || filterList.isEmpty()) {
                            ExtPointWizardSelectionListPage.addElement(nodes, element);
                        } else if (filterList.contains(id)) {
                            ExtPointWizardSelectionListPage.addElement(nodes, element);
                        } else if (!forceWizardIds) {
                            IConfigurationElement[] iConfigurationElementArray2 = element.getChildren(EXT_CAN_REPLACE);
                            int n5 = iConfigurationElementArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement replElement = iConfigurationElementArray2[n6];
                                String replId = replElement.getAttribute(EXT_ID);
                                if (filterList.contains(replId)) {
                                    ExtPointWizardSelectionListPage.addElement(nodes, element);
                                    break;
                                }
                                ++n6;
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return nodes.toArray(new IWizardSelectionNode[0]);
    }

    private static void addElement(Vector<IWizardSelectionNode> nodes, IConfigurationElement element) {
        String id = element.getAttribute(EXT_ID);
        String name = element.getAttribute(EXT_NAME);
        String iconName = element.getAttribute(EXT_ICON);
        Image icon = null;
        ImageDescriptor iconDesc = null;
        if (iconName != null) {
            String pluginId = element.getContributor().getName();
            iconDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconName);
        }
        if (iconDesc != null) {
            icon = iconDesc.createImage();
        }
        ExtPointWizardSelectionNode wizardNode = new ExtPointWizardSelectionNode(element, id, name, icon);
        nodes.add(wizardNode);
    }
}

