/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.workflow.ui.navigator;

import eu.geclipse.workflow.model.IWorkflowElement;
import eu.geclipse.workflow.ui.internal.WorkflowDiagramEditorPlugin;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorGroup;
import eu.geclipse.workflow.ui.navigator.WorkflowNavigatorItem;
import eu.geclipse.workflow.ui.part.WorkflowVisualIDRegistry;
import eu.geclipse.workflow.ui.providers.WorkflowElementTypes;
import eu.geclipse.workflow.ui.providers.WorkflowParserProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class WorkflowNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        WorkflowDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?InvalidElement", ImageDescriptor.getMissingImageDescriptor());
        WorkflowDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        WorkflowDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof WorkflowNavigatorItem && !this.isOwnView(((WorkflowNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof WorkflowNavigatorGroup) {
            WorkflowNavigatorGroup group = (WorkflowNavigatorGroup)((Object)element);
            return WorkflowDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof WorkflowNavigatorItem) {
            WorkflowNavigatorItem navigatorItem = (WorkflowNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (WorkflowVisualIDRegistry.getVisualID(view)) {
            case 1001: {
                return this.getImage("Navigator?TopLevelNode?http:///eu/geclipse/workflow.ecore?IWorkflowJob", WorkflowElementTypes.IWorkflowJob_1001);
            }
            case 2001: {
                return this.getImage("Navigator?Node?http:///eu/geclipse/workflow.ecore?IOutputPort", WorkflowElementTypes.IOutputPort_2001);
            }
            case 2002: {
                return this.getImage("Navigator?Node?http:///eu/geclipse/workflow.ecore?IInputPort", WorkflowElementTypes.IInputPort_2002);
            }
            case 79: {
                return this.getImage("Navigator?Diagram?http:///eu/geclipse/workflow.ecore?IWorkflow", WorkflowElementTypes.IWorkflow_79);
            }
            case 3001: {
                return this.getImage("Navigator?Link?http:///eu/geclipse/workflow.ecore?ILink", WorkflowElementTypes.ILink_3001);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = WorkflowDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && WorkflowElementTypes.isKnownElementType(elementType)) {
            image = WorkflowElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof WorkflowNavigatorGroup) {
            WorkflowNavigatorGroup group = (WorkflowNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof WorkflowNavigatorItem) {
            WorkflowNavigatorItem navigatorItem = (WorkflowNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (WorkflowVisualIDRegistry.getVisualID(view)) {
            case 1001: {
                return this.getIWorkflowJob_1001Text(view);
            }
            case 2001: {
                return this.getIOutputPort_2001Text(view);
            }
            case 2002: {
                return this.getIInputPort_2002Text(view);
            }
            case 79: {
                return this.getIWorkflow_79Text(view);
            }
            case 3001: {
                return this.getILink_3001Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getIWorkflowJob_1001Text(View view) {
        WorkflowParserProvider.HintAdapter hintAdapter = new WorkflowParserProvider.HintAdapter(WorkflowElementTypes.IWorkflowJob_1001, (EObject)(view.getElement() != null ? view.getElement() : view), WorkflowVisualIDRegistry.getType(4001));
        IParser parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        if (parser != null) {
            return parser.getPrintString((IAdaptable)hintAdapter, ParserOptions.NONE.intValue());
        }
        WorkflowDiagramEditorPlugin.getInstance().logError("Parser was not found for label 4001");
        return "";
    }

    private String getIOutputPort_2001Text(View view) {
        EObject domainModelElement = view.getElement();
        if (domainModelElement != null) {
            return ((IWorkflowElement)domainModelElement).getName();
        }
        WorkflowDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 2001");
        return "";
    }

    private String getIInputPort_2002Text(View view) {
        EObject domainModelElement = view.getElement();
        if (domainModelElement != null) {
            return ((IWorkflowElement)domainModelElement).getName();
        }
        WorkflowDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 2002");
        return "";
    }

    private String getIWorkflow_79Text(View view) {
        EObject domainModelElement = view.getElement();
        if (domainModelElement != null) {
            return ((IWorkflowElement)domainModelElement).getName();
        }
        WorkflowDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 79");
        return "";
    }

    private String getILink_3001Text(View view) {
        EObject domainModelElement = view.getElement();
        if (domainModelElement != null) {
            return ((IWorkflowElement)domainModelElement).getName();
        }
        WorkflowDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3001");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "Workflow".equals(WorkflowVisualIDRegistry.getModelID(view));
    }
}

