/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IWrappedElement;
import eu.geclipse.ui.dialogs.ProblemDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractAWSProjectAction
implements IObjectActionDelegate {
    private IWorkbenchPart workbenchPart;
    private AWSVirtualOrganization awsVo;

    public abstract void run(IAction var1);

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void extractAWSVoFromCategory(ISelection selectedCategory) {
        IGridElement resourceCat;
        IGridProject project;
        IStructuredSelection strucSel;
        Object firstElement;
        if (selectedCategory instanceof IStructuredSelection && (firstElement = (strucSel = (IStructuredSelection)selectedCategory).getFirstElement()) instanceof IGridElement && (project = (resourceCat = (IGridElement)firstElement).getProject()) != null) {
            IVirtualOrganization vo = project.getVO();
            if (vo instanceof IWrappedElement) {
                IWrappedElement wrappedElement = (IWrappedElement)vo;
                vo = wrappedElement.getWrappedElement();
            }
            if (vo instanceof AWSVirtualOrganization) {
                AWSVirtualOrganization awsVo;
                this.awsVo = awsVo = (AWSVirtualOrganization)vo;
            }
        }
    }

    protected void extractAWSVoFromGridElement(IGridElement gridElement) {
        if (gridElement == null) {
            this.awsVo = null;
        } else if (gridElement instanceof AWSVirtualOrganization) {
            this.awsVo = (AWSVirtualOrganization)gridElement;
        } else if (gridElement instanceof IGridProject) {
            IGridProject gridProject = (IGridProject)gridElement;
            this.extractAWSVoFromGridElement((IGridElement)gridProject.getVO());
        } else if (gridElement instanceof IWrappedElement) {
            IWrappedElement wrappedVo = (IWrappedElement)gridElement;
            this.extractAWSVoFromGridElement(wrappedVo.getWrappedElement());
        } else {
            this.extractAWSVoFromGridElement((IGridElement)gridElement.getParent());
        }
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    protected AWSVirtualOrganization getAwsVo() {
        return this.awsVo;
    }

    protected void processException(Throwable throwable, final String description) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            cause = throwable;
        }
        final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", cause.getLocalizedMessage(), throwable, "eu.geclipse.aws.ec2.ui");
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("AbstractAWSProjectAction.problem_title"), (String)description, (Throwable)exception);
            }
        });
    }
}

