/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2SecurityGroup;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecurityGroupAction
implements IObjectActionDelegate {
    public static int ENABLE_FOR_ONE = 1;
    public static int ENABLE_FOR_MANY = 2 | ENABLE_FOR_ONE;
    private IWorkbenchPart workbenchPart;
    private List<EC2SecurityGroup> securityGroupList = new ArrayList<EC2SecurityGroup>();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.securityGroupList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2SecurityGroup)) continue;
                EC2SecurityGroup securityGroup = (EC2SecurityGroup)element;
                this.securityGroupList.add(securityGroup);
            }
        }
        if ((this.getEnablementCount() ^ ENABLE_FOR_ONE) == 0 && this.securityGroupList.size() == 1) {
            enable = true;
        } else if ((this.getEnablementCount() ^ ENABLE_FOR_MANY) == 0 && this.securityGroupList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }

    protected abstract int getEnablementCount();

    public IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    public List<EC2SecurityGroup> getSecurityGroupList() {
        return this.securityGroupList;
    }
}

