/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpAllocateAddress;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.core.reporting.ProblemException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class AllocateElasticIPAction
extends AbstractAWSProjectAction {
    public void run(IAction action) {
        Job job = new Job(Messages.getString("AllocateElasticIPAction.job_title")){

            protected IStatus run(IProgressMonitor monitor) {
                IEC2 ec2;
                monitor.beginTask(Messages.getString("AllocateElasticIPAction.monitor_title"), 2);
                try {
                    ec2 = EC2Registry.getRegistry().getEC2(AllocateElasticIPAction.this.getAwsVo());
                }
                catch (ProblemException problemEx) {
                    Activator.log("Can not obtain IEC2 instance", (Exception)((Object)problemEx));
                    return Status.CANCEL_STATUS;
                }
                EC2OpAllocateAddress opAllocateElasticIP = new EC2OpAllocateAddress(ec2);
                new OperationExecuter().execOp((IOperation)opAllocateElasticIP);
                if (opAllocateElasticIP.getException() != null) {
                    Exception cause = opAllocateElasticIP.getException();
                    AllocateElasticIPAction.this.processException(cause, Messages.getString("AllocateElasticIPAction.problem_description"));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.extractAWSVoFromCategory(selection);
    }
}

