/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.wizards.AssociateElasticIPWizard;
import eu.geclipse.core.model.IGridElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class AssociateElasticIPAction
extends AbstractAWSProjectAction {
    private List<EC2Instance> instanceList = new ArrayList<EC2Instance>();

    public void run(IAction action) {
        EC2Instance firstInstance = null;
        if (this.instanceList.size() > 0) {
            firstInstance = this.instanceList.get(0);
            this.extractAWSVoFromGridElement((IGridElement)firstInstance);
            AssociateElasticIPWizard associateElasticIPWizard = new AssociateElasticIPWizard(this.getAwsVo(), this.instanceList.get(0));
            WizardDialog wizardDialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)associateElasticIPWizard);
            wizardDialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.instanceList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2Instance)) continue;
                EC2Instance ec2Instance = (EC2Instance)element;
                this.instanceList.add(ec2Instance);
            }
        }
        if (this.instanceList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

