/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Keypair;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDeleteKeypair;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class DeleteKeypairAction
extends AbstractAWSProjectAction {
    private List<EC2Keypair> keypairList = new ArrayList<EC2Keypair>();

    public void run(IAction action) {
        if (action.isEnabled()) {
            StringBuffer strBuf = new StringBuffer();
            String dash = "- ";
            String newLine = "\n";
            for (EC2Keypair keypair : this.keypairList) {
                strBuf.append(String.valueOf(dash) + keypair.getName() + newLine);
            }
            Shell shell = this.getWorkbenchPart().getSite().getShell();
            boolean confirmation = MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("DeleteKeypairAction.dialog_delete_keypair_title"), (String)(String.valueOf(Messages.getString("DeleteKeypairAction.dialog_delete_keypair_description")) + newLine + newLine + strBuf.toString()));
            if (confirmation) {
                this.deleteKeypairs();
            }
        }
    }

    private void deleteKeypairs() {
        Job job = new Job(Messages.getString("DeleteKeypairAction.job_title")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        monitor.beginTask(Messages.getString("DeleteKeypairAction.monitor_title"), 2);
                        EC2Keypair ec2Keypair = (EC2Keypair)DeleteKeypairAction.this.keypairList.get(0);
                        DeleteKeypairAction.this.extractAWSVoFromGridElement((IGridElement)ec2Keypair);
                        IEC2 ec2 = EC2Registry.getRegistry().getEC2(DeleteKeypairAction.this.getAwsVo());
                        monitor.worked(1);
                        EC2OpDeleteKeypair opDeleteKeypair = new EC2OpDeleteKeypair(ec2, ec2Keypair.getKeyPairInfo().getKeyName());
                        new OperationExecuter().execOp((IOperation)opDeleteKeypair);
                        if (opDeleteKeypair.getException() != null) {
                            DeleteKeypairAction.this.processException(opDeleteKeypair.getException(), MessageFormat.format(Messages.getString("DeleteKeypairAction.problem_could_not_delete_keypair_description"), ec2Keypair.getName()));
                        }
                    }
                    catch (ProblemException problemEx) {
                        DeleteKeypairAction.this.processException(problemEx, Messages.getString("DeleteKeypairAction.problem_no_ec2_description"));
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.keypairList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2Keypair)) continue;
                EC2Keypair ec2Keypair = (EC2Keypair)element;
                this.keypairList.add(ec2Keypair);
            }
        }
        if (this.keypairList.size() == 1) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

