/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import com.xerox.amazonws.ec2.AddressInfo;
import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDescribeAddresses;
import eu.geclipse.aws.ec2.op.EC2OpDisassociateAddress;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DisassociateElasticIPAction
extends AbstractAWSProjectAction {
    private List<EC2Instance> instanceList = new ArrayList<EC2Instance>();

    public void run(IAction action) {
        final EC2Instance ec2Instance = this.instanceList.get(0);
        Job job = new Job(MessageFormat.format(Messages.getString("DisassociateElasticIPAction.job_title"), ec2Instance.getInstanceId())){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(MessageFormat.format(Messages.getString("DisassociateElasticIPAction.monitor_title"), ec2Instance.getInstanceId()), 3);
                IEC2 ec2 = null;
                try {
                    DisassociateElasticIPAction.this.extractAWSVoFromGridElement((IGridElement)ec2Instance);
                    ec2 = EC2Registry.getRegistry().getEC2(DisassociateElasticIPAction.this.getAwsVo());
                }
                catch (ProblemException problemEx) {
                    Activator.log("Can not obtain IEC2 instance", (Exception)((Object)problemEx));
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
                OperationExecuter operationExecuter = new OperationExecuter();
                monitor.subTask(Messages.getString("DisassociateElasticIPAction.monitor_subtask_fetch_elastic_ip_to_instance_id_mapping"));
                String elasticIP = this.fetchMappedElasticIP(ec2Instance, ec2, operationExecuter);
                if (elasticIP != null) {
                    monitor.subTask(MessageFormat.format(Messages.getString("DisassociateElasticIPAction.monitor_subtask_disassociating_elastic_ip"), elasticIP, ec2Instance.getInstanceId()));
                    EC2OpDisassociateAddress opDisassociateAddress = new EC2OpDisassociateAddress(ec2, elasticIP);
                    operationExecuter.execOp((IOperation)opDisassociateAddress);
                    if (opDisassociateAddress.getException() != null) {
                        Exception cause = opDisassociateAddress.getException();
                        DisassociateElasticIPAction.this.processException(cause, Messages.getString("DisassociateElasticIPAction.problem_description_could_not_disassociate_elastic_ip"));
                        return Status.CANCEL_STATUS;
                    }
                } else {
                    Exception exception = new Exception(MessageFormat.format(Messages.getString("DisassociateElasticIPAction.exception_description_no_elastic_ip_bound_to_instance"), ec2Instance.getInstanceId()));
                    DisassociateElasticIPAction.this.processException(exception, Messages.getString("DisassociateElasticIPAction.problem_description_could_not_disassociate_elastic_ip"));
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private String fetchMappedElasticIP(EC2Instance ec2Instance2, IEC2 ec2, OperationExecuter operationExecuter) {
                EC2OpDescribeAddresses opDescribeAddresses = new EC2OpDescribeAddresses(ec2);
                operationExecuter.execOp((IOperation)opDescribeAddresses);
                if (opDescribeAddresses.getException() != null) {
                    Exception cause = opDescribeAddresses.getException();
                    DisassociateElasticIPAction.this.processException(cause, Messages.getString("DisassociateElasticIPAction.problem_description_could_not_describe_elastic_ips"));
                }
                String elasticIP = null;
                for (AddressInfo addressInfo : opDescribeAddresses.getResult()) {
                    if (!addressInfo.getInstanceId().equals(ec2Instance2.getInstanceId())) continue;
                    elasticIP = addressInfo.getPublicIp();
                }
                return elasticIP;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.instanceList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2Instance)) continue;
                EC2Instance ec2Instance = (EC2Instance)element;
                this.instanceList.add(ec2Instance);
            }
        }
        if (this.instanceList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

