/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class LaunchAMI
implements IObjectActionDelegate {
    private static final String EXTERNAL_TOOLS_LAUNCH_GROUP = "org.eclipse.ui.externaltools.launchGroup";
    private ArrayList<EC2AMIImage> amiList = new ArrayList();
    private IWorkbenchPart workbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void run(IAction action) {
        if (action.isEnabled()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("eu.geclipse.aws.ec2.launch.ec2LaunchConfigurationType");
            ILaunchConfigurationWorkingCopy ec2LaunchConfig = null;
            String amiId = null;
            if (this.amiList != null && this.amiList.size() > 0) {
                amiId = this.amiList.get(0).getImageId();
            }
            ILaunchConfiguration savedLaunchConfig = null;
            try {
                ILaunchConfiguration[] launchConfigurations = manager.getLaunchConfigurations(type);
                String launchName = this.createUniqueName(launchConfigurations, amiId, 0);
                String awsAccessId = null;
                EC2AMIImage ami = this.amiList.get(0);
                if (ami != null) {
                    EC2AMIImage ec2AMIImage = ami;
                    EC2Service ec2Service = ec2AMIImage.getEC2Service();
                    AWSVirtualOrganization awsVo = (AWSVirtualOrganization)ec2Service.getParent();
                    try {
                        awsAccessId = awsVo.getProperties().getAwsAccessId();
                    }
                    catch (ProblemException problemEx) {
                        Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
                    }
                }
                ec2LaunchConfig = type.newInstance(null, launchName);
                ec2LaunchConfig.setAttribute("amiId", amiId);
                ec2LaunchConfig.setAttribute("awsAccessId", awsAccessId);
                savedLaunchConfig = ec2LaunchConfig.doSave();
            }
            catch (CoreException coreEx) {
                Activator.log("Could not initiate launch wizard", (Exception)((Object)coreEx));
            }
            DebugUITools.openLaunchConfigurationDialog((Shell)this.workbenchPart.getSite().getShell(), savedLaunchConfig, (String)EXTERNAL_TOOLS_LAUNCH_GROUP, null);
        }
    }

    private String createUniqueName(ILaunchConfiguration[] launchConfigurations, String amiId, int i) {
        String tempAmi = amiId;
        if (i > 0) {
            tempAmi = String.valueOf(amiId) + " (" + i + ")";
        }
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration existingLaunchConfig = iLaunchConfigurationArray[n2];
            if (existingLaunchConfig.getName().equals(tempAmi)) {
                return this.createUniqueName(launchConfigurations, amiId, ++i);
            }
            ++n2;
        }
        return tempAmi;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.amiList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2AMIImage)) continue;
                EC2AMIImage amiImage = (EC2AMIImage)element;
                this.amiList.add(amiImage);
            }
        }
        if (this.amiList.size() == 1) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

