/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpRegisterImage;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RegisterImageAction
extends AbstractAWSProjectAction {
    private ArrayList<IGridConnectionElement> connectionElementList = new ArrayList();

    public void run(IAction action) {
        Job job = new Job(Messages.getString("RegisterImageAction.job_title")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IEC2 ec2;
                    if (RegisterImageAction.this.connectionElementList.size() == 0) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.beginTask(Messages.getString("RegisterImageAction.monitor_title"), 2);
                    RegisterImageAction.this.extractAWSVoFromGridElement((IGridElement)RegisterImageAction.this.connectionElementList.get(0));
                    try {
                        ec2 = EC2Registry.getRegistry().getEC2(RegisterImageAction.this.getAwsVo());
                    }
                    catch (ProblemException problemEx) {
                        Activator.log("Can not obtain IEC2 instance", (Exception)((Object)problemEx));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    monitor.worked(1);
                    IPath path = ((IGridConnectionElement)RegisterImageAction.this.connectionElementList.get(0)).getPath();
                    String[] segments = path.segments();
                    StringBuilder strBldr = new StringBuilder();
                    strBldr.append(segments[segments.length - 2]);
                    strBldr.append('/');
                    strBldr.append(segments[segments.length - 1]);
                    EC2OpRegisterImage opRegisterImage = new EC2OpRegisterImage(ec2, strBldr.toString());
                    new OperationExecuter().execOp((IOperation)opRegisterImage);
                    if (opRegisterImage.getException() != null) {
                        Exception cause = opRegisterImage.getException();
                        RegisterImageAction.this.processException(cause, Messages.getString("RegisterImageAction.problem_description"));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.connectionElementList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof IGridConnectionElement)) continue;
                IGridConnectionElement connElem = (IGridConnectionElement)element;
                this.connectionElementList.add(connElem);
            }
        }
        if (this.connectionElementList.size() == 1) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

