/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.actions;

import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpTerminateInstances;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.service.EC2Service;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TerminateInstance
implements IActionDelegate {
    private ArrayList<EC2Instance> instanceList = new ArrayList();

    public void run(IAction action) {
        if (action.isEnabled()) {
            Job job = new Job(Messages.getString("TerminateInstance.job_title")){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.getString("TerminateInstance.monitor_title"), 2);
                    ArrayList<String> instanceIds = new ArrayList<String>();
                    for (EC2Instance ec2Instance : TerminateInstance.this.instanceList) {
                        instanceIds.add(ec2Instance.getInstanceId());
                    }
                    monitor.worked(1);
                    EC2Instance firstInstance = null;
                    if (TerminateInstance.this.instanceList.size() <= 0) {
                        return Status.CANCEL_STATUS;
                    }
                    firstInstance = (EC2Instance)TerminateInstance.this.instanceList.get(0);
                    EC2Service ec2Service = firstInstance.getEC2Service();
                    AWSVirtualOrganization awsVo = (AWSVirtualOrganization)ec2Service.getParent();
                    String awsAccessId = null;
                    try {
                        awsAccessId = awsVo.getProperties().getAwsAccessId();
                    }
                    catch (ProblemException problemEx) {
                        Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
                    }
                    IEC2 ec2 = EC2Registry.getRegistry().getEC2(awsAccessId);
                    EC2OpTerminateInstances opTerminateInstances = new EC2OpTerminateInstances(ec2, instanceIds);
                    OperationExecuter operationExecuter = new OperationExecuter();
                    operationExecuter.execOp((IOperation)opTerminateInstances);
                    monitor.done();
                    if (opTerminateInstances.getException() != null) {
                        Exception cause = opTerminateInstances.getException();
                        final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", cause.getCause().getLocalizedMessage(), (Throwable)cause, "eu.geclipse.aws.ec2.ui");
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        display.asyncExec(new Runnable(){

                            public void run() {
                                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("TerminateInstance.error_problem_with_ec2_title"), (String)Messages.getString("TerminateInstance.error_problem_with_ec2_description"), (Throwable)exception);
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setUser(true);
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        this.instanceList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof EC2Instance)) continue;
                EC2Instance ec2Instance = (EC2Instance)element;
                this.instanceList.add(ec2Instance);
            }
        }
        if (this.instanceList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

