/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.launch;

import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.KeyPairInfo;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDescribeAvailabilityZones;
import eu.geclipse.aws.ec2.op.EC2OpDescribeKeypairs;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.op.OperationSet;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.SecurityGroupSelectionWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EC2MainTab
extends AbstractLaunchConfigurationTab
implements KeyListener,
SelectionListener {
    private Text amiIdText;
    private Text minCountText;
    private Text maxCountText;
    private Combo keyNameCombo;
    private Combo zoneCombo;
    private ILaunchConfiguration launchConfiguration;
    private Combo comboInstanceType;
    private org.eclipse.swt.widgets.List listSecurityGroups;
    private Text awsAccessIdText;

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(2, false));
        Group awsGroup = new Group(mainComp, 0);
        awsGroup.setLayout((Layout)new GridLayout(2, false));
        awsGroup.setText(Messages.getString("EC2MainTab.group_aws_credentials"));
        GridData gData = new GridData(4, 0x1000000, true, false, 2, 0);
        awsGroup.setLayoutData((Object)gData);
        Label awsAccessIdlabel = new Label((Composite)awsGroup, 16384);
        awsAccessIdlabel.setText(Messages.getString("EC2MainTab.label_aws_access_id"));
        awsAccessIdlabel.setLayoutData((Object)new GridData());
        this.awsAccessIdText = new Text((Composite)awsGroup, 18436);
        gData = new GridData(4, 0x1000000, true, false);
        this.awsAccessIdText.setLayoutData((Object)gData);
        this.awsAccessIdText.addKeyListener((KeyListener)this);
        Group amiGroup = new Group(mainComp, 0);
        amiGroup.setLayout((Layout)new GridLayout(6, false));
        amiGroup.setText(Messages.getString("EC2MainTab.group_ami_title"));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.horizontalSpan = 2;
        amiGroup.setLayoutData((Object)gData);
        Label amiIdLabel = new Label((Composite)amiGroup, 16384);
        amiIdLabel.setText(Messages.getString("EC2MainTab.label_ami_id"));
        amiIdLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_ami_id"));
        amiIdLabel.setLayoutData((Object)new GridData());
        this.amiIdText = new Text((Composite)amiGroup, 18436);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.amiIdText.setLayoutData((Object)gData);
        this.amiIdText.addKeyListener((KeyListener)this);
        Label minCountLabel = new Label((Composite)amiGroup, 131072);
        minCountLabel.setText(Messages.getString("EC2MainTab.label_min"));
        minCountLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_min"));
        gData = new GridData(0x1000008, 0x1000000, false, false);
        gData.horizontalIndent = 5;
        minCountLabel.setLayoutData((Object)gData);
        this.minCountText = new Text((Composite)amiGroup, 18436);
        this.minCountText.setText(Messages.getString("EC2MainTab.text_min_default"));
        gData = new GridData(0x1000008, 0x1000000, false, false);
        gData.widthHint = 30;
        this.minCountText.setLayoutData((Object)gData);
        this.minCountText.addKeyListener((KeyListener)this);
        Label maxCountLabel = new Label((Composite)amiGroup, 131072);
        maxCountLabel.setText(Messages.getString("EC2MainTab.label_max"));
        maxCountLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_max"));
        gData = new GridData(0x1000008, 0x1000000, false, false);
        maxCountLabel.setLayoutData((Object)gData);
        this.maxCountText = new Text((Composite)amiGroup, 18436);
        this.maxCountText.setText(Messages.getString("EC2MainTab.text_max_default"));
        gData = new GridData(0x1000008, 0x1000000, false, false);
        gData.widthHint = 30;
        this.maxCountText.setLayoutData((Object)gData);
        this.maxCountText.addKeyListener((KeyListener)this);
        Label keyNameLabel = new Label((Composite)amiGroup, 16384);
        keyNameLabel.setText(Messages.getString("EC2MainTab.label_key_name"));
        keyNameLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_key_name"));
        gData = new GridData();
        keyNameLabel.setLayoutData((Object)gData);
        this.keyNameCombo = new Combo((Composite)amiGroup, 18436);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.horizontalSpan = 5;
        this.keyNameCombo.setLayoutData((Object)gData);
        this.keyNameCombo.addKeyListener((KeyListener)this);
        this.keyNameCombo.addSelectionListener((SelectionListener)this);
        Group imageGroup = new Group(mainComp, 0);
        imageGroup.setLayout((Layout)new GridLayout(2, false));
        imageGroup.setText(Messages.getString("EC2MainTab.group_image_title"));
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        gData.horizontalSpan = 2;
        imageGroup.setLayoutData((Object)gData);
        Label instanceTypeLabel = new Label((Composite)imageGroup, 16384);
        instanceTypeLabel.setText(Messages.getString("EC2MainTab.label_instance_type"));
        instanceTypeLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_instance_type"));
        gData = new GridData();
        instanceTypeLabel.setLayoutData((Object)gData);
        this.comboInstanceType = new Combo((Composite)imageGroup, 18444);
        this.comboInstanceType.addSelectionListener((SelectionListener)this);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.comboInstanceType.setLayoutData((Object)gData);
        String[] instanceTypesReadable = new String[]{Messages.getString("EC2MainTab.instance_type_small"), Messages.getString("EC2MainTab.instance_type_large"), Messages.getString("EC2MainTab.instance_type_extra_large"), Messages.getString("EC2MainTab.instance_type_high_cpu_medium"), Messages.getString("EC2MainTab.instance_type_high_cpu_large")};
        InstanceType[] instanceTypes = InstanceType.values();
        int i = 0;
        while (i < instanceTypes.length) {
            instanceTypesReadable[i] = String.valueOf(instanceTypesReadable[i]) + " (" + instanceTypes[i].getTypeId() + ")";
            ++i;
        }
        this.comboInstanceType.setItems(instanceTypesReadable);
        Label securityGroupLabel = new Label((Composite)imageGroup, 16384);
        securityGroupLabel.setText(Messages.getString("EC2MainTab.label_security_group"));
        securityGroupLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_security_group"));
        gData = new GridData(16384, 128, false, false);
        securityGroupLabel.setLayoutData((Object)gData);
        Composite secGroup = new Composite((Composite)imageGroup, 0);
        gData = new GridData(4, 0x1000000, true, false);
        secGroup.setLayoutData((Object)gData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        secGroup.setLayout((Layout)gridLayout);
        this.listSecurityGroups = new org.eclipse.swt.widgets.List(secGroup, 2564);
        gData = new GridData(768);
        gData.heightHint = 100;
        gData.grabExcessHorizontalSpace = true;
        this.listSecurityGroups.setLayoutData((Object)gData);
        Button buttonEditSecGr = new Button(secGroup, 0);
        buttonEditSecGr.setText(Messages.getString("EC2MainTab.button_security_group_edit"));
        buttonEditSecGr.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        buttonEditSecGr.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String awsAccessId = EC2MainTab.this.awsAccessIdText.getText().trim();
                SecurityGroupSelectionWizard securityGroupSelectionWizard = new SecurityGroupSelectionWizard(awsAccessId);
                List<String> groupsList = Arrays.asList(EC2MainTab.this.listSecurityGroups.getItems());
                securityGroupSelectionWizard.setSecurityGroups(groupsList);
                WizardDialog wizardDialog = new WizardDialog(EC2MainTab.this.getShell(), (IWizard)securityGroupSelectionWizard);
                int code = wizardDialog.open();
                if (code == 0) {
                    List<String> secGroups = securityGroupSelectionWizard.getSecurityGroups();
                    EC2MainTab.this.listSecurityGroups.removeAll();
                    for (String secGroup : secGroups) {
                        EC2MainTab.this.listSecurityGroups.add(secGroup);
                    }
                    EC2MainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Label zoneLabel = new Label((Composite)imageGroup, 16384);
        zoneLabel.setText(Messages.getString("EC2MainTab.label_zone"));
        zoneLabel.setToolTipText(Messages.getString("EC2MainTab.tooltip_zone"));
        gData = new GridData();
        zoneLabel.setLayoutData((Object)gData);
        this.zoneCombo = new Combo((Composite)imageGroup, 18436);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.zoneCombo.setLayoutData((Object)gData);
        this.zoneCombo.addKeyListener((KeyListener)this);
        this.zoneCombo.addSelectionListener((SelectionListener)this);
        Link linkPopulate = new Link(mainComp, 0);
        linkPopulate.setText(Messages.getString("EC2MainTab.link_populate_from_ec2"));
        gData = new GridData(131072, 0x1000000, true, false, 2, 0);
        linkPopulate.setLayoutData((Object)gData);
        linkPopulate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EC2Registry ec2Registry = EC2Registry.getRegistry();
                IEC2 ec2 = ec2Registry.getEC2(EC2MainTab.this.awsAccessIdText.getText().trim());
                EC2MainTab.this.populateFromEC2(ec2);
            }
        });
        this.setControl((Control)mainComp);
    }

    public String getName() {
        return Messages.getString("EC2MainTab.tab_title");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.launchConfiguration = configuration;
        String emptyString = "";
        String oneString = "1";
        try {
            this.amiIdText.setText(configuration.getAttribute("amiId", emptyString));
            this.awsAccessIdText.setText(configuration.getAttribute("awsAccessId", emptyString));
            this.minCountText.setText(configuration.getAttribute("minCount", oneString));
            this.maxCountText.setText(configuration.getAttribute("maxCount", oneString));
            this.keyNameCombo.setText(configuration.getAttribute("keyName", emptyString));
            List securityGroupsList = configuration.getAttribute("securityGroup", new ArrayList());
            String[] securityGroupsArray = new String[securityGroupsList.size()];
            int j = 0;
            for (Object object : securityGroupsList) {
                securityGroupsArray[j] = object.toString();
                ++j;
            }
            this.listSecurityGroups.setItems(securityGroupsArray);
            this.zoneCombo.setText(configuration.getAttribute("zone", emptyString));
            String instanceTypeString = configuration.getAttribute("instanceType", emptyString);
            InstanceType[] instanceTypes = InstanceType.values();
            int instanceTypeIndex = 0;
            int i = 0;
            while (i < instanceTypes.length) {
                if (instanceTypes[i].getTypeId().equals(instanceTypeString)) {
                    instanceTypeIndex = i;
                    break;
                }
                ++i;
            }
            this.comboInstanceType.select(instanceTypeIndex);
        }
        catch (CoreException coreEx) {
            Activator.log("Could not prepopulate launch dialog", (Exception)((Object)coreEx));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("amiId", this.amiIdText.getText().trim());
        configuration.setAttribute("awsAccessId", this.awsAccessIdText.getText().trim());
        configuration.setAttribute("minCount", this.minCountText.getText().trim());
        configuration.setAttribute("maxCount", this.maxCountText.getText().trim());
        configuration.setAttribute("keyName", this.keyNameCombo.getText().trim());
        String[] secGroups = this.listSecurityGroups.getItems();
        List<String> secGroupsList = Arrays.asList(secGroups);
        configuration.setAttribute("securityGroup", secGroupsList);
        configuration.setAttribute("zone", this.zoneCombo.getText().trim());
        int selectionIndex = this.comboInstanceType.getSelectionIndex();
        InstanceType[] instanceTypes = InstanceType.values();
        configuration.setAttribute("instanceType", instanceTypes[selectionIndex].getTypeId());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void populateFromEC2(final IEC2 ec2) {
        try {
            ILaunchConfigurationDialog lcd = this.getLaunchConfigurationDialog();
            lcd.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.getString("EC2MainTab.monitor_get_ec2_presets_title"), 2);
                    EC2OpDescribeAvailabilityZones opDescZones = new EC2OpDescribeAvailabilityZones(ec2);
                    EC2OpDescribeKeypairs opDescKeypairs = new EC2OpDescribeKeypairs(ec2);
                    OperationSet operationSet = new OperationSet();
                    operationSet.addOp((IOperation)opDescZones);
                    operationSet.addOp((IOperation)opDescKeypairs);
                    OperationExecuter operationExecuter = new OperationExecuter();
                    operationExecuter.execOpGroup(operationSet);
                    monitor.worked(1);
                    for (IOperation op : operationSet.getOps()) {
                        if (op.getException() == null) continue;
                        monitor.done();
                        throw new InvocationTargetException(op.getException());
                    }
                    String zoneString = EC2MainTab.this.zoneCombo.getText().trim();
                    EC2MainTab.this.zoneCombo.removeAll();
                    List resultZones = opDescZones.getResult();
                    int i = 0;
                    int select = -1;
                    for (AvailabilityZone zone : resultZones) {
                        EC2MainTab.this.zoneCombo.add(zone.getName());
                        if (zone.getName().equals(zoneString)) {
                            select = i;
                        }
                        ++i;
                    }
                    if (select == -1) {
                        if (zoneString.length() != 0) {
                            EC2MainTab.this.zoneCombo.add(zoneString, 0);
                        }
                        select = 0;
                    }
                    EC2MainTab.this.zoneCombo.select(select);
                    String keyNameString = EC2MainTab.this.keyNameCombo.getText().trim();
                    EC2MainTab.this.keyNameCombo.removeAll();
                    List resultKeypairs = opDescKeypairs.getResult();
                    i = 0;
                    select = -1;
                    for (KeyPairInfo keyPairInfo : resultKeypairs) {
                        EC2MainTab.this.keyNameCombo.add(keyPairInfo.getKeyName());
                        if (keyPairInfo.getKeyName().equals(keyNameString)) {
                            select = i;
                        }
                        ++i;
                    }
                    if (select == -1) {
                        if (keyNameString.length() != 0) {
                            EC2MainTab.this.keyNameCombo.add(keyNameString, 0);
                        }
                        select = 0;
                    }
                    EC2MainTab.this.keyNameCombo.select(select);
                    monitor.done();
                }
            });
        }
        catch (Exception ex) {
            Activator.log("Could not populate fields in Main EC2 Launch Tab", ex);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        try {
            this.performApply(this.launchConfiguration.getWorkingCopy());
            this.updateLaunchConfigurationDialog();
        }
        catch (CoreException coreEx) {
            Activator.log("Problems applying the launch configuration", (Exception)((Object)coreEx));
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String error = null;
        if (this.awsAccessIdText.getText().trim().length() == 0) {
            error = Messages.getString("EC2MainTab.error_aws_access_id_required");
        }
        if (this.amiIdText.getText().trim().length() == 0) {
            error = Messages.getString("EC2MainTab.error_validation_no_ami");
        }
        int minNum = 0;
        try {
            minNum = Integer.parseInt(this.minCountText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            error = Messages.getString("EC2MainTab.error_validation_no_valid_min");
        }
        if (error == null && minNum <= 0) {
            error = Messages.getString("EC2MainTab.error_validation_min_smaller_than_1");
        }
        int maxNum = 0;
        try {
            maxNum = Integer.parseInt(this.maxCountText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            error = Messages.getString("EC2MainTab.error_validation_no_valid_max");
        }
        if (error == null && maxNum <= 0) {
            error = Messages.getString("EC2MainTab.error_validation_max_smaller_than_1");
        }
        if (error == null && minNum > maxNum) {
            error = Messages.getString("EC2MainTab.error_validation_min_larger_than_max");
        }
        if (error != null) {
            this.setErrorMessage(error);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateLaunchConfigurationDialog();
        try {
            this.performApply(this.launchConfiguration.getWorkingCopy());
        }
        catch (CoreException coreEx) {
            Activator.log("Problems applying the launch configuration", (Exception)((Object)coreEx));
        }
    }
}

