/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.properties;

import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.properties.SimpleProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMIImagePropertySource
extends AbstractPropertySource<Object> {
    private List<IProperty<Object>> propertiesList;
    private EC2AMIImage ec2AmiImage;

    public AMIImagePropertySource(EC2AMIImage sourceObject) {
        super((Object)sourceObject);
        this.ec2AmiImage = sourceObject;
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected List<IProperty<Object>> getStaticProperties() {
        if (this.propertiesList == null) {
            this.propertiesList = this.getProperties();
        }
        return this.propertiesList;
    }

    private List<IProperty<Object>> getProperties() {
        ArrayList<IProperty<Object>> propertyList = new ArrayList<IProperty<Object>>();
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("AMIImagePropertySource.property_image_id"), this.ec2AmiImage.getImageId()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("AMIImagePropertySource.property_location"), this.ec2AmiImage.getImageLocation()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("AMIImagePropertySource.property_owner"), this.ec2AmiImage.getImageOwnerId()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("AMIImagePropertySource.property_state"), this.ec2AmiImage.getImageState()));
        StringBuilder strBuilder = new StringBuilder();
        List productCodes = this.ec2AmiImage.getProductCodes();
        Iterator iterator = productCodes.iterator();
        while (iterator.hasNext()) {
            String productCode = (String)iterator.next();
            strBuilder.append(productCode);
            if (!iterator.hasNext()) continue;
            strBuilder.append(", ");
        }
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("AMIImagePropertySource.property_product_code"), strBuilder.toString()));
        return propertyList;
    }
}

