/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.properties;

import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.properties.SimpleProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2InstancePropertySource
extends AbstractPropertySource<Object> {
    private List<IProperty<Object>> propertiesList;
    private EC2Instance ec2Instance;

    public EC2InstancePropertySource(EC2Instance sourceObject) {
        super((Object)sourceObject);
        this.ec2Instance = sourceObject;
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected List<IProperty<Object>> getStaticProperties() {
        if (this.propertiesList == null) {
            this.propertiesList = this.getProperties();
        }
        return this.propertiesList;
    }

    private List<IProperty<Object>> getProperties() {
        ArrayList<IProperty<Object>> propertyList = new ArrayList<IProperty<Object>>();
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_instance_id"), this.ec2Instance.getInstanceId()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_image_id"), this.ec2Instance.getImageId()));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Messages.getString("EC2InstancePropertySource.property_launch_time_format"));
        String formatedDate = simpleDateFormat.format(this.ec2Instance.getLaunchTime().getTime());
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_launch_time"), formatedDate));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_dns_name"), this.ec2Instance.getDnsName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_private_dns_name"), this.ec2Instance.getPrivateDnsName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_availability_zone"), this.ec2Instance.getAvailabilityZone()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_key_name"), this.ec2Instance.getKeyName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_instance_type"), this.ec2Instance.getInstanceType()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_kernel_id"), this.ec2Instance.getKernelId()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_ramdisk_id"), this.ec2Instance.getRamdiskId()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_state"), String.valueOf(this.ec2Instance.getState()) + " (" + this.ec2Instance.getStateCode() + ")"));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("EC2InstancePropertySource.property_reason"), this.ec2Instance.getReason()));
        return propertyList;
    }
}

