/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.properties;

import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.EC2ElasticIPAddress;
import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2Keypair;
import eu.geclipse.aws.ec2.EC2SecurityGroup;
import eu.geclipse.aws.ec2.ui.properties.AMIImagePropertySource;
import eu.geclipse.aws.ec2.ui.properties.EC2InstancePropertySource;
import eu.geclipse.aws.ec2.ui.properties.ElasticIPPropertySource;
import eu.geclipse.aws.ec2.ui.properties.KeypairPropertySource;
import eu.geclipse.aws.ec2.ui.properties.SecurityGroupPropertySource;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IPropertiesFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2PropertiesFactory
implements IPropertiesFactory {
    private ArrayList<AbstractPropertySource<?>> sourcesList;

    public List<AbstractPropertySource<?>> getPropertySources(Object sourceObject) {
        if (this.sourcesList == null) {
            this.sourcesList = new ArrayList();
            if (sourceObject instanceof EC2AMIImage) {
                this.sourcesList.add(new AMIImagePropertySource((EC2AMIImage)sourceObject));
            }
            if (sourceObject instanceof EC2Instance) {
                this.sourcesList.add(new EC2InstancePropertySource((EC2Instance)sourceObject));
            }
            if (sourceObject instanceof EC2Keypair) {
                this.sourcesList.add(new KeypairPropertySource((EC2Keypair)sourceObject));
            }
            if (sourceObject instanceof EC2SecurityGroup) {
                this.sourcesList.add(new SecurityGroupPropertySource((EC2SecurityGroup)sourceObject));
            }
            if (sourceObject instanceof EC2ElasticIPAddress) {
                this.sourcesList.add(new ElasticIPPropertySource((EC2ElasticIPAddress)sourceObject));
            }
        }
        return this.sourcesList;
    }
}

