/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.properties;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.EC2SecurityGroup;
import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.properties.SimpleProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityGroupPropertySource
extends AbstractPropertySource<Object> {
    private EC2SecurityGroup ec2securityGroup;
    private List<IProperty<Object>> propertiesList;

    public SecurityGroupPropertySource(EC2SecurityGroup sourceObject) {
        super((Object)sourceObject);
        this.ec2securityGroup = sourceObject;
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected List<IProperty<Object>> getStaticProperties() {
        if (this.propertiesList == null) {
            this.propertiesList = this.getProperties();
        }
        return this.propertiesList;
    }

    private List<IProperty<Object>> getProperties() {
        ArrayList<IProperty<Object>> propertyList = new ArrayList<IProperty<Object>>();
        GroupDescription groupDescription = this.ec2securityGroup.getGroupDescription();
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("SecurityGroupPropertySource.property_name"), groupDescription.getName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("SecurityGroupPropertySource.property_description"), groupDescription.getDescription()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("SecurityGroupPropertySource.property_owner"), groupDescription.getOwner()));
        int i = 1;
        for (GroupDescription.IpPermission ipPerm : groupDescription.getPermissions()) {
            StringBuilder ipRanges = new StringBuilder();
            Iterator iterator = ipPerm.getIpRanges().iterator();
            while (iterator.hasNext()) {
                String range = (String)iterator.next();
                ipRanges.append(range);
                if (!iterator.hasNext()) continue;
                ipRanges.append(", ");
            }
            List uidGroupPairs = ipPerm.getUidGroupPairs();
            Iterator iterator2 = uidGroupPairs.iterator();
            while (iterator2.hasNext()) {
                String[] uidGroupPair = (String[])iterator2.next();
                ipRanges.append(uidGroupPair[0]);
                ipRanges.append(":");
                ipRanges.append(uidGroupPair[1]);
                if (!iterator2.hasNext()) continue;
                ipRanges.append(", ");
            }
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(ipPerm.getProtocol());
            strBuilder.append(": ");
            strBuilder.append(ipPerm.getFromPort());
            strBuilder.append(" - ");
            strBuilder.append(ipPerm.getToPort());
            strBuilder.append(", ");
            strBuilder.append((CharSequence)ipRanges);
            String value = strBuilder.toString();
            propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("SecurityGroupPropertySource.property_permissions"), String.valueOf(i), value));
            ++i;
        }
        return propertyList;
    }
}

