/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpAuthorizeSecurityGroup;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.CIDRPermissionWizardPage;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CIDRPermissionWizard
extends Wizard {
    private GroupDescription securityGroupName;
    private CIDRPermissionWizardPage wizardPage;
    private String awsAccessId;

    public CIDRPermissionWizard(GroupDescription securityGroupName, String awsAccessId) {
        this.securityGroupName = securityGroupName;
        this.awsAccessId = awsAccessId;
    }

    public void addPages() {
        this.wizardPage = new CIDRPermissionWizardPage(this.securityGroupName);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("CIDRPermissionWizard.wizard_title");
    }

    public boolean performFinish() {
        if (this.wizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IEC2 ec2 = null;
                        ec2 = EC2Registry.getRegistry().getEC2(CIDRPermissionWizard.this.awsAccessId);
                        EC2OpAuthorizeSecurityGroup opAuthorizeSecurityGroup = new EC2OpAuthorizeSecurityGroup(ec2, CIDRPermissionWizard.this.securityGroupName.getName(), CIDRPermissionWizard.this.wizardPage.getCidr(), CIDRPermissionWizard.this.wizardPage.getProtocol(), CIDRPermissionWizard.this.wizardPage.getFromPort(), CIDRPermissionWizard.this.wizardPage.getToPort());
                        OperationExecuter operationExecuter = new OperationExecuter();
                        operationExecuter.execOp((IOperation)opAuthorizeSecurityGroup);
                        if (opAuthorizeSecurityGroup.getException() != null) {
                            throw new InvocationTargetException(opAuthorizeSecurityGroup.getException());
                        }
                    }
                });
            }
            catch (Exception ex) {
                Activator.log("A problem occured while authorizing security group access", ex);
                final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("CIDRPermissionWizard.problem_title"), (String)Messages.getString("CIDRPermissionWizard.problem_description"), (Throwable)exception);
                    }
                });
                return false;
            }
            return true;
        }
        return false;
    }
}

