/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import eu.geclipse.aws.ec2.ui.Messages;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import java.io.File;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class CreateKeypairWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizards.createKeypairWizardPage";
    private Text textName;
    private Text textKeyPath;

    public CreateKeypairWizardPage(AWSVirtualOrganization awsVo) {
        super(WIZARD_PAGE_ID, Messages.getString("CreateKeypairWizardPage.page_title"), null);
        String awsAccessId = null;
        try {
            awsAccessId = awsVo.getProperties().getAwsAccessId();
            this.setDescription(String.valueOf(Messages.getString("CreateKeypairWizardPage.page_description1")) + awsAccessId + Messages.getString("CreateKeypairWizardPage.page_description2"));
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not read aws vo properties", (Exception)((Object)problemEx));
        }
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/security_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        mainComp.setLayout((Layout)new GridLayout(1, true));
        Group group = new Group(mainComp, 0);
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(Messages.getString("CreateKeypairWizardPage.group_keypair_title"));
        Label labelName = new Label((Composite)group, 0);
        labelName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelName.setText(Messages.getString("CreateKeypairWizardPage.label_name"));
        this.textName = new Text((Composite)group, 18436);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 0));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateKeypairWizardPage.this.validatePage();
            }
        });
        Label labelKeyPath = new Label((Composite)group, 0);
        labelKeyPath.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelKeyPath.setText(Messages.getString("CreateKeypairWizardPage.label_key_path"));
        this.textKeyPath = new Text((Composite)group, 18436);
        this.textKeyPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textKeyPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateKeypairWizardPage.this.validatePage();
            }
        });
        Button button = new Button((Composite)group, 8);
        button.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        button.setText(Messages.getString("CreateKeypairWizardPage.button_browse"));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog fileDialog = new FileDialog(CreateKeypairWizardPage.this.getContainer().getShell(), 4096);
                fileDialog.setText(Messages.getString("CreateKeypairWizardPage.save_key_as"));
                String dialogResult = fileDialog.open();
                CreateKeypairWizardPage.this.textKeyPath.setText(dialogResult);
            }
        });
        this.setControl((Control)group);
    }

    private boolean validatePage() {
        String error = null;
        if (this.textName.getText().trim().length() == 0) {
            error = Messages.getString("CreateKeypairWizardPage.error_name_required");
        } else if (this.textKeyPath.getText().trim().length() == 0) {
            error = Messages.getString("CreateKeypairWizardPage.error_file_path_required");
        }
        File keyFile = new File(this.textKeyPath.getText().trim());
        if (keyFile.isDirectory()) {
            error = Messages.getString("CreateKeypairWizardPage.error_fiel_path_can_not_be_directory");
        }
        if (error != null) {
            this.setErrorMessage(error);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    public String getKeypairName() {
        return this.textName.getText().trim();
    }

    public String getKeypairPath() {
        return this.textKeyPath.getText().trim();
    }
}

