/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.DescribeImageAttributeResult;
import com.xerox.amazonws.ec2.ImageAttribute;
import com.xerox.amazonws.ec2.ImageListAttribute;
import com.xerox.amazonws.ec2.ImageListAttributeItem;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.LaunchPermissionAttribute;
import com.xerox.amazonws.ec2.ProductCodesAttribute;
import eu.geclipse.aws.ec2.EC2AMIImage;
import eu.geclipse.aws.ec2.EC2ProblemException;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDescribeImageAttributes;
import eu.geclipse.aws.ec2.op.EC2OpModifyImageAttribute;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.op.OperationSet;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.AddAttributeWizard;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditAMIAttributesWizardPage
extends WizardPage {
    private static final String GROUP_PERMISSION_ALL = "all";
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizards.editAMIAttributesWizardPage";
    private AWSVirtualOrganization awsVo;
    private EC2AMIImage ami;
    private Table tableAttrib;
    private DescribeImageAttributeResult attributesLaunchPerm;
    private DescribeImageAttributeResult attributesProductCodes;
    private Button buttonRemLaunchPerm;
    private Button buttonMakeAMIPublic;

    public EditAMIAttributesWizardPage(AWSVirtualOrganization awsVo, EC2AMIImage ami) {
        super(WIZARD_PAGE_ID, Messages.getString("EditAMIAttributesWizardPage.page_title"), null);
        this.setDescription(MessageFormat.format(Messages.getString("EditAMIAttributesWizardPage.page_description"), ami.getImageId()));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/service_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.awsVo = awsVo;
        this.ami = ami;
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComp.setLayout((Layout)new GridLayout(2, false));
        this.tableAttrib = new Table(mainComp, 68358);
        this.tableAttrib.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableAttrib.setLinesVisible(true);
        this.tableAttrib.setHeaderVisible(true);
        this.tableAttrib.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditAMIAttributesWizardPage.this.updateRemoveButtonStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TableColumn tableColumnAttrib = new TableColumn(this.tableAttrib, 16384);
        tableColumnAttrib.setText(Messages.getString("EditAMIAttributesWizardPage.table_attrib_column_attribute"));
        TableColumn tableColumnIdentifier = new TableColumn(this.tableAttrib, 16384);
        tableColumnIdentifier.setText(Messages.getString("EditAMIAttributesWizardPage.table_attrib_column_identifier"));
        TableColumn tableColumnValue = new TableColumn(this.tableAttrib, 16384);
        tableColumnValue.setText(Messages.getString("EditAMIAttributesWizardPage.table_attrib_column_value"));
        int i = 0;
        while (i < this.tableAttrib.getColumnCount()) {
            this.tableAttrib.getColumn(i).pack();
            ++i;
        }
        Composite buttonComp = new Composite(mainComp, 0);
        buttonComp.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        buttonComp.setLayout((Layout)new GridLayout(1, false));
        Button buttonAddLaunchPermission = new Button(buttonComp, 8);
        buttonAddLaunchPermission.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonAddLaunchPermission.setText(Messages.getString("EditAMIAttributesWizardPage.button_add_launch_permission"));
        buttonAddLaunchPermission.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WizardDialog wizardDialog = new WizardDialog(EditAMIAttributesWizardPage.this.getContainer().getShell(), (IWizard)new AddAttributeWizard(EditAMIAttributesWizardPage.this.awsVo, EditAMIAttributesWizardPage.this.ami));
                int wizardReturnCode = wizardDialog.open();
                if (wizardReturnCode == 0) {
                    EditAMIAttributesWizardPage.this.refreshAttributesTable();
                }
            }
        });
        this.buttonRemLaunchPerm = new Button(buttonComp, 8);
        this.buttonRemLaunchPerm.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonRemLaunchPerm.setText(Messages.getString("EditAMIAttributesWizardPage.button_remove_launch_permission"));
        this.buttonRemLaunchPerm.setEnabled(false);
        this.buttonRemLaunchPerm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditAMIAttributesWizardPage.this.removeAttributes();
            }
        });
        this.buttonMakeAMIPublic = new Button(buttonComp, 8);
        this.buttonMakeAMIPublic.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 0, 12));
        this.buttonMakeAMIPublic.setText(Messages.getString("EditAMIAttributesWizardPage.button_make_ami_public"));
        this.buttonMakeAMIPublic.setEnabled(true);
        this.buttonMakeAMIPublic.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean confirmation = MessageDialog.openConfirm((Shell)EditAMIAttributesWizardPage.this.getContainer().getShell(), (String)MessageFormat.format(Messages.getString("EditAMIAttributesWizardPage.dialog_ami_public_title"), EditAMIAttributesWizardPage.this.ami.getImageId()), (String)MessageFormat.format(Messages.getString("EditAMIAttributesWizardPage.dialog_ami_public_description"), EditAMIAttributesWizardPage.this.ami.getImageId()));
                if (confirmation) {
                    EditAMIAttributesWizardPage.this.makeAMIPublic();
                }
            }
        });
        Button buttonAddProductCode = new Button(buttonComp, 8);
        buttonAddProductCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonAddProductCode.setText(Messages.getString("EditAMIAttributesWizardPage.button_add_product_code"));
        buttonAddProductCode.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditAMIAttributesWizardPage.this.addProductCode();
            }
        });
        Link refreshLink = new Link(mainComp, 0);
        refreshLink.setText(Messages.getString("EditAMIAttributesWizardPage.link_refresh_attributes"));
        refreshLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditAMIAttributesWizardPage.this.refreshAttributesTable();
            }
        });
        refreshLink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 12, 0));
        this.refreshAttributesTable();
        this.setControl((Control)mainComp);
    }

    protected void addProductCode() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.getString("EditAMIAttributesWizardPage.task_adding_product_code"), 2);
                        EC2Registry registry = EC2Registry.getRegistry();
                        try {
                            InputDialog inputDialog = new InputDialog(EditAMIAttributesWizardPage.this.getContainer().getShell(), Messages.getString("EditAMIAttributesWizardPage.dialog_add_product_id_title"), Messages.getString("EditAMIAttributesWizardPage.dialog_add_product_id_description"), null, new IInputValidator(){

                                public String isValid(String newText) {
                                    if (newText.trim().length() == 0) {
                                        return Messages.getString("EditAMIAttributesWizardPage.dialog_add_product_id_error_product_id_needed");
                                    }
                                    return null;
                                }
                            });
                            inputDialog.open();
                            if (inputDialog.getReturnCode() == 0) {
                                IEC2 ec2 = registry.getEC2(EditAMIAttributesWizardPage.this.awsVo);
                                ProductCodesAttribute attribute = new ProductCodesAttribute();
                                attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.productCode, inputDialog.getValue().trim());
                                EC2OpModifyImageAttribute op = new EC2OpModifyImageAttribute(ec2, EditAMIAttributesWizardPage.this.ami.getImageId(), (ImageListAttribute)attribute, Jec2.ImageListAttributeOperationType.add);
                                new OperationExecuter().execOp((IOperation)op);
                                if (op.getException() != null) {
                                    throw new InvocationTargetException(op.getException());
                                }
                            }
                        }
                        catch (ProblemException problemEx) {
                            throw new InvocationTargetException(problemEx);
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            Activator.log("An problem occured while adding a product code", ex);
            final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("EditAMIAttributesWizardPage.problem_add_product_code_title"), (String)Messages.getString("EditAMIAttributesWizardPage.problem_add_product_code_description"), (Throwable)exception);
                }
            });
        }
        this.refreshAttributesTable();
    }

    protected void makeAMIPublic() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.getString("EditAMIAttributesWizardPage.task_make_ami_public"), 2);
                        EC2Registry registry = EC2Registry.getRegistry();
                        try {
                            IEC2 ec2 = registry.getEC2(EditAMIAttributesWizardPage.this.awsVo);
                            LaunchPermissionAttribute attribute = new LaunchPermissionAttribute();
                            attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.group, EditAMIAttributesWizardPage.GROUP_PERMISSION_ALL);
                            EC2OpModifyImageAttribute op = new EC2OpModifyImageAttribute(ec2, EditAMIAttributesWizardPage.this.ami.getImageId(), (ImageListAttribute)attribute, Jec2.ImageListAttributeOperationType.add);
                            new OperationExecuter().execOp((IOperation)op);
                            if (op.getException() != null) {
                                throw new InvocationTargetException(op.getException());
                            }
                            EditAMIAttributesWizardPage.this.refreshAttributesTable();
                        }
                        catch (ProblemException problemEx) {
                            throw new InvocationTargetException(problemEx);
                        }
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            Activator.log("An problem occured while adding public group permissions", ex);
            final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("EditAMIAttributesWizardPage.problem_add_group_permission_title"), (String)Messages.getString("EditAMIAttributesWizardPage.problem_add_group_permission_description"), (Throwable)exception);
                }
            });
        }
    }

    protected void removeAttributes() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        TableItem[] selection;
                        IEC2 ec2;
                        monitor.beginTask(Messages.getString("EditAMIAttributesWizardPage.task_removing_permissions"), 2);
                        EC2Registry registry = EC2Registry.getRegistry();
                        try {
                            ec2 = registry.getEC2(EditAMIAttributesWizardPage.this.awsVo);
                        }
                        catch (ProblemException problemEx) {
                            throw new InvocationTargetException(problemEx);
                        }
                        monitor.worked(1);
                        LaunchPermissionAttribute attribute = new LaunchPermissionAttribute();
                        TableItem[] tableItemArray = selection = EditAMIAttributesWizardPage.this.tableAttrib.getSelection();
                        int n = selection.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.valueOf((String)tableItem.getText(1)), tableItem.getText(2));
                            ++n2;
                        }
                        EC2OpModifyImageAttribute op = new EC2OpModifyImageAttribute(ec2, EditAMIAttributesWizardPage.this.ami.getImageId(), (ImageListAttribute)attribute, Jec2.ImageListAttributeOperationType.remove);
                        new OperationExecuter().execOp((IOperation)op);
                        if (op.getException() != null) {
                            throw new InvocationTargetException(op.getException());
                        }
                        EditAMIAttributesWizardPage.this.refreshAttributesTable();
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            Activator.log("An problem occured while removing permissions", ex);
            final EC2ProblemException exception = new EC2ProblemException("eu.geclipse.aws.ec2.problem.net.ec2", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.ec2.ui");
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("EditAMIAttributesWizardPage.problem_remove_permission_title"), (String)Messages.getString("EditAMIAttributesWizardPage.problem_remove_permission_description"), (Throwable)exception);
                }
            });
        }
    }

    protected void refreshAttributesTable() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.getString("EditAMIAttributesWizardPage.task_fetching_attributes"), EditAMIAttributesWizardPage.this.ami.getImageId()), 2);
                    try {
                        try {
                            IEC2 ec2 = null;
                            ec2 = EC2Registry.getRegistry().getEC2(EditAMIAttributesWizardPage.this.awsVo);
                            EC2OpDescribeImageAttributes opLaunchPerms = new EC2OpDescribeImageAttributes(ec2, EditAMIAttributesWizardPage.this.ami.getImageId(), ImageAttribute.ImageAttributeType.launchPermission);
                            EC2OpDescribeImageAttributes opProdCodes = new EC2OpDescribeImageAttributes(ec2, EditAMIAttributesWizardPage.this.ami.getImageId(), ImageAttribute.ImageAttributeType.productCodes);
                            OperationSet operationSet = new OperationSet();
                            operationSet.addOp((IOperation)opLaunchPerms);
                            operationSet.addOp((IOperation)opProdCodes);
                            new OperationExecuter().execOpGroup(operationSet);
                            monitor.worked(1);
                            if (opLaunchPerms.getException() != null) {
                                throw new InvocationTargetException(opLaunchPerms.getException().getCause());
                            }
                            if (opProdCodes.getException() != null) {
                                throw new InvocationTargetException(opProdCodes.getException().getCause());
                            }
                            EditAMIAttributesWizardPage.this.attributesLaunchPerm = opLaunchPerms.getResult();
                            EditAMIAttributesWizardPage.this.attributesProductCodes = opProdCodes.getResult();
                            this.updateAttribTable();
                            monitor.worked(2);
                        }
                        catch (ProblemException problemEx) {
                            new InvocationTargetException(problemEx, "Could not obtain EC2 instance");
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }

                private void updateAttribTable() {
                    TableItem tableItem;
                    EditAMIAttributesWizardPage.this.tableAttrib.removeAll();
                    ImageListAttribute attribLaunchPerm = EditAMIAttributesWizardPage.this.attributesLaunchPerm.getImageListAttribute();
                    ImageListAttribute attribProductCode = EditAMIAttributesWizardPage.this.attributesProductCodes.getImageListAttribute();
                    EditAMIAttributesWizardPage.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            EditAMIAttributesWizardPage.this.buttonMakeAMIPublic.setEnabled(true);
                        }
                    });
                    for (ImageListAttributeItem imageListAttributeItem : attribLaunchPerm.getImageListAttributeItems()) {
                        tableItem = new TableItem(EditAMIAttributesWizardPage.this.tableAttrib, 0);
                        String attribute = attribLaunchPerm.getType().toString();
                        String permissionType = imageListAttributeItem.getType().toString();
                        String attribValue = imageListAttributeItem.getValue();
                        if (permissionType.equals(ImageListAttribute.ImageListAttributeItemType.group.toString()) && attribValue.equals(EditAMIAttributesWizardPage.GROUP_PERMISSION_ALL)) {
                            EditAMIAttributesWizardPage.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EditAMIAttributesWizardPage.this.buttonMakeAMIPublic.setEnabled(false);
                                }
                            });
                        }
                        tableItem.setText(new String[]{attribute, permissionType, attribValue});
                    }
                    for (ImageListAttributeItem imageListAttributeItem : attribProductCode.getImageListAttributeItems()) {
                        tableItem = new TableItem(EditAMIAttributesWizardPage.this.tableAttrib, 0);
                        tableItem.setText(new String[]{attribLaunchPerm.getType().toString(), imageListAttributeItem.getType().toString(), imageListAttributeItem.getValue()});
                    }
                    int i = 0;
                    while (i < EditAMIAttributesWizardPage.this.tableAttrib.getColumnCount()) {
                        EditAMIAttributesWizardPage.this.tableAttrib.getColumn(i).pack();
                        ++i;
                    }
                    EditAMIAttributesWizardPage.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            EditAMIAttributesWizardPage.this.updateRemoveButtonStatus();
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException invTargetEx) {
            Activator.log("An problem occured while reading security group access", invTargetEx);
        }
        catch (InterruptedException interruptedEx) {
            Activator.log("The thread was interrupted while reading security group access", interruptedEx);
        }
    }

    private void updateRemoveButtonStatus() {
        TableItem[] selection = this.tableAttrib.getSelection();
        if (selection.length > 0) {
            this.buttonRemLaunchPerm.setEnabled(true);
        } else {
            this.buttonRemLaunchPerm.setEnabled(false);
        }
    }
}

