/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpAuthorizeSecurityGroup;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.GroupPermissionWizardPage;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class GroupPermissionWizard
extends Wizard {
    private GroupDescription securityGroupName;
    private GroupPermissionWizardPage wizardPage;
    private String awsAccessId;

    public GroupPermissionWizard(GroupDescription securityGroupName, String awsAccessId) {
        this.securityGroupName = securityGroupName;
        this.awsAccessId = awsAccessId;
    }

    public void addPages() {
        this.wizardPage = new GroupPermissionWizardPage(this.securityGroupName);
        this.addPage((IWizardPage)this.wizardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("GroupPermissionWizard.wizard_title");
    }

    public boolean performFinish() {
        if (this.wizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        IEC2 ec2 = EC2Registry.getRegistry().getEC2(GroupPermissionWizard.this.awsAccessId);
                        EC2OpAuthorizeSecurityGroup opAuthorizeSecurityGroup = new EC2OpAuthorizeSecurityGroup(ec2, GroupPermissionWizard.this.securityGroupName.getName(), GroupPermissionWizard.this.wizardPage.getGroup(), GroupPermissionWizard.this.wizardPage.getAccountId());
                        OperationExecuter operationExecuter = new OperationExecuter();
                        operationExecuter.execOp((IOperation)opAuthorizeSecurityGroup);
                        if (opAuthorizeSecurityGroup.getException() != null) {
                            ProblemDialog.openProblem((Shell)GroupPermissionWizard.this.getContainer().getShell(), (String)Messages.getString("GroupPermissionWizard.problem_title"), (String)Messages.getString("GroupPermissionWizard.problem_description"), (Throwable)opAuthorizeSecurityGroup.getException().getCause());
                            throw new InvocationTargetException(opAuthorizeSecurityGroup.getException());
                        }
                    }
                });
            }
            catch (InvocationTargetException invTargetEx) {
                Activator.log("An problem occured while authorizing security group access", invTargetEx);
            }
            catch (InterruptedException interruptedEx) {
                Activator.log("The thread was interrupted while authorizing security group access", interruptedEx);
            }
            return true;
        }
        return false;
    }
}

