/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.GroupDescription;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDescribeSecurityGroups;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityGroupSelectionWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizard.securityGroupSelection";
    private org.eclipse.swt.widgets.List listSecGrAvailable;
    private org.eclipse.swt.widgets.List listSecGrSelected;
    private ArrayList<String> availableGroups;
    private ArrayList<String> selectedGroups;
    private String awsAccessId;

    protected SecurityGroupSelectionWizardPage(String awsAccessId) {
        super(WIZARD_PAGE_ID, Messages.getString("SecurityGroupSelectionWizardPage.page_title"), null);
        this.setDescription(Messages.getString("SecurityGroupSelectionWizardPage.page_description"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/security_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.awsAccessId = awsAccessId;
        this.availableGroups = new ArrayList();
        this.selectedGroups = new ArrayList();
    }

    private void addGroup(String groupToAdd) {
        if (this.availableGroups.contains(groupToAdd)) {
            this.selectedGroups.add(groupToAdd);
            this.availableGroups.remove(groupToAdd);
        }
    }

    protected void addGroup(String[] groupsToAdd) {
        String[] stringArray = groupsToAdd;
        int n = groupsToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            this.addGroup(group);
            ++n2;
        }
        this.updateFromModel();
    }

    private void removeGroup(String groupToRemove) {
        if (this.selectedGroups.contains(groupToRemove)) {
            this.availableGroups.add(groupToRemove);
            this.selectedGroups.remove(groupToRemove);
        }
        this.updateFromModel();
    }

    private void removeGroup(String[] groupsToRemove) {
        String[] stringArray = groupsToRemove;
        int n = groupsToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            this.removeGroup(group);
            ++n2;
        }
    }

    public void initialiseSelectedGroups(List<String> groups) {
        for (String group : groups) {
            this.selectedGroups.add(group);
        }
    }

    protected void initialiseAvailableGroups(List<String> groupsList) {
        this.availableGroups.clear();
        for (String group : groupsList) {
            if (this.selectedGroups.contains(group)) continue;
            this.availableGroups.add(group);
        }
        for (String group : this.selectedGroups) {
            if (groupsList.contains(group)) continue;
            this.selectedGroups.remove(group);
        }
        this.updateFromModel();
    }

    protected void updateFromModel() {
        Collections.sort(this.availableGroups);
        this.listSecGrAvailable.removeAll();
        for (String group : this.availableGroups) {
            this.listSecGrAvailable.add(group);
        }
        Collections.sort(this.selectedGroups);
        this.listSecGrSelected.removeAll();
        for (String group : this.selectedGroups) {
            this.listSecGrSelected.add(group);
        }
    }

    public List<String> getSelectedSecurityGroups() {
        return this.selectedGroups;
    }

    public void createControl(Composite parent) {
        Composite secGroup = new Composite(parent, 0);
        GridData gData = new GridData(4, 4, true, true);
        secGroup.setLayoutData((Object)gData);
        GridLayout gridLayout = new GridLayout(3, false);
        secGroup.setLayout((Layout)gridLayout);
        Label labelSecGroupAvailable = new Label(secGroup, 0);
        labelSecGroupAvailable.setText(Messages.getString("SecurityGroupSelectionWizardPage.label_available"));
        gData = new GridData();
        gData.horizontalSpan = 2;
        labelSecGroupAvailable.setLayoutData((Object)gData);
        Label labelSecGroupSelected = new Label(secGroup, 0);
        labelSecGroupSelected.setText(Messages.getString("SecurityGroupSelectionWizardPage.label_selected"));
        gData = new GridData();
        labelSecGroupSelected.setLayoutData((Object)gData);
        this.listSecGrAvailable = new org.eclipse.swt.widgets.List(secGroup, 2562);
        gData = new GridData(4, 4, true, true);
        this.listSecGrAvailable.setLayoutData((Object)gData);
        this.listSecGrAvailable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SecurityGroupSelectionWizardPage.this.addGroup(SecurityGroupSelectionWizardPage.this.listSecGrAvailable.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Composite secGroupButComp = new Composite(secGroup, 0);
        secGroupButComp.setLayout((Layout)new GridLayout(1, true));
        secGroupButComp.setLayoutData((Object)new GridData(1040));
        Button buttonAddSecGr = new Button(secGroupButComp, 0);
        buttonAddSecGr.setText(Messages.getString("SecurityGroupSelectionWizardPage.button_add_group"));
        buttonAddSecGr.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SecurityGroupSelectionWizardPage.this.addGroup(SecurityGroupSelectionWizardPage.this.listSecGrAvailable.getSelection());
            }
        });
        Button buttonRemSecGr = new Button(secGroupButComp, 0);
        buttonRemSecGr.setText(Messages.getString("SecurityGroupSelectionWizardPage.button_remove_group"));
        buttonRemSecGr.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SecurityGroupSelectionWizardPage.this.removeGroup(SecurityGroupSelectionWizardPage.this.listSecGrSelected.getSelection());
            }
        });
        this.listSecGrSelected = new org.eclipse.swt.widgets.List(secGroup, 2562);
        gData = new GridData(4, 4, true, true);
        this.listSecGrSelected.setLayoutData((Object)gData);
        this.listSecGrSelected.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SecurityGroupSelectionWizardPage.this.removeGroup(SecurityGroupSelectionWizardPage.this.listSecGrSelected.getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Link linkPopulate = new Link(secGroup, 0);
        linkPopulate.setText(Messages.getString("SecurityGroupSelectionWizardPage.link_populate_from_ec2"));
        gData = new GridData(16384, 0x1000000, true, false);
        linkPopulate.setLayoutData((Object)gData);
        linkPopulate.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EC2Registry ec2Registry = EC2Registry.getRegistry();
                IEC2 ec2 = ec2Registry.getEC2(SecurityGroupSelectionWizardPage.this.awsAccessId);
                SecurityGroupSelectionWizardPage.this.populateFromEC2(ec2);
            }
        });
        this.setControl((Control)secGroup);
        EC2Registry ec2Registry = EC2Registry.getRegistry();
        IEC2 ec2 = ec2Registry.getEC2(this.awsAccessId);
        this.populateFromEC2(ec2);
        this.updateFromModel();
    }

    private void populateFromEC2(IEC2 ec2) {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.getString("SecurityGroupSelectionWizardPage.task_title"), 2);
                        EC2Registry ec2Registry = EC2Registry.getRegistry();
                        IEC2 ec2 = ec2Registry.getEC2(SecurityGroupSelectionWizardPage.this.awsAccessId);
                        EC2OpDescribeSecurityGroups opDescSec = new EC2OpDescribeSecurityGroups(ec2);
                        OperationExecuter operationExecuter = new OperationExecuter();
                        operationExecuter.execOp((IOperation)opDescSec);
                        monitor.worked(1);
                        if (opDescSec.getException() != null) {
                            throw new InvocationTargetException(opDescSec.getException());
                        }
                        List result = opDescSec.getResult();
                        ArrayList<String> groupsList = new ArrayList<String>(result.size());
                        for (GroupDescription groupDescription : result) {
                            groupsList.add(groupDescription.getName());
                        }
                        SecurityGroupSelectionWizardPage.this.initialiseAvailableGroups(groupsList);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (Exception ex) {
            ProblemDialog.openProblem((Shell)this.getContainer().getShell(), (String)Messages.getString("SecurityGroupSelectionWizardPage.problem_title"), (String)Messages.getString("SecurityGroupSelectionWizardPage.problem_description"), (Throwable)ex.getCause());
            Activator.log("Could not populate fields in Main EC2 Launch Tab", ex);
        }
    }
}

