/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ec2.ui.wizards;

import com.xerox.amazonws.ec2.AddressInfo;
import eu.geclipse.aws.ec2.EC2Instance;
import eu.geclipse.aws.ec2.EC2Registry;
import eu.geclipse.aws.ec2.IEC2;
import eu.geclipse.aws.ec2.op.EC2OpDescribeAddresses;
import eu.geclipse.aws.ec2.op.IOperation;
import eu.geclipse.aws.ec2.op.OperationExecuter;
import eu.geclipse.aws.ec2.ui.internal.Activator;
import eu.geclipse.aws.ec2.ui.wizards.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectElasticIPWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ec2.ui.wizard.elasticIp";
    private AWSVirtualOrganization awsVo;
    private Table tableElasticIPs;

    public SelectElasticIPWizardPage(AWSVirtualOrganization awsVo, EC2Instance ec2Instance) {
        super(WIZARD_PAGE_ID, Messages.getString("SelectElasticIPWizardPage.wizard_page_title"), null);
        this.setDescription(MessageFormat.format(Messages.getString("SelectElasticIPWizardPage.wizard_page_description"), ec2Instance.getInstanceId()));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/service_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.awsVo = awsVo;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        this.tableElasticIPs = new Table(mainComp, 67588);
        this.tableElasticIPs.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableElasticIPs.setLinesVisible(true);
        this.tableElasticIPs.setHeaderVisible(true);
        this.tableElasticIPs.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] selection = SelectElasticIPWizardPage.this.tableElasticIPs.getSelection();
                if (selection.length > 0) {
                    SelectElasticIPWizardPage.this.setPageComplete(true);
                }
            }
        });
        TableColumn tableColumnElasticIP = new TableColumn(this.tableElasticIPs, 16384);
        tableColumnElasticIP.setText(Messages.getString("SelectElasticIPWizardPage.table_elastic_ip_column_elastic_ip_title"));
        TableColumn tableColumnInstanceId = new TableColumn(this.tableElasticIPs, 16384);
        tableColumnInstanceId.setText(Messages.getString("SelectElasticIPWizardPage.table_elastic_ip_column_instance_id_title"));
        int i = 0;
        while (i < this.tableElasticIPs.getColumnCount()) {
            this.tableElasticIPs.getColumn(i).pack();
            ++i;
        }
        Link refreshLink = new Link(mainComp, 0);
        refreshLink.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        refreshLink.setText(Messages.getString("SelectElasticIPWizardPage.link_refresh_elastic_ips"));
        refreshLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SelectElasticIPWizardPage.this.refreshElasticIPs();
                SelectElasticIPWizardPage.this.setPageComplete(false);
            }
        });
        this.setControl((Control)mainComp);
        this.refreshElasticIPs();
    }

    protected void refreshElasticIPs() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(Messages.getString("SelectElasticIPWizardPage.monitor_title"), 2);
                            EC2Registry registry = EC2Registry.getRegistry();
                            IEC2 ec2 = registry.getEC2(SelectElasticIPWizardPage.this.awsVo);
                            EC2OpDescribeAddresses opDescribeAddresses = new EC2OpDescribeAddresses(ec2);
                            monitor.worked(1);
                            new OperationExecuter().execOp((IOperation)opDescribeAddresses);
                            if (opDescribeAddresses.getException() != null) {
                                throw new InvocationTargetException(opDescribeAddresses.getException().getCause());
                            }
                            SelectElasticIPWizardPage.this.populateElasticIPTable(opDescribeAddresses.getResult());
                        }
                        catch (ProblemException problemEx) {
                            Activator.log("Could not obtain IEC2 instance", (Exception)((Object)problemEx));
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invTargetEx) {
            Activator.log("An problem occured while refreshing the elastic IPs", invTargetEx);
        }
        catch (InterruptedException interruptedEx) {
            Activator.log("The thread was interrupted while refreshing the elastic IPs", interruptedEx);
        }
    }

    protected void populateElasticIPTable(List<AddressInfo> addressInfos) {
        String none = "none";
        this.tableElasticIPs.removeAll();
        for (AddressInfo addressInfo : addressInfos) {
            String instanceId = addressInfo.getInstanceId();
            if (instanceId.length() == 0) {
                instanceId = none;
            }
            String[] fields = new String[]{addressInfo.getPublicIp(), instanceId};
            TableItem tableItem = new TableItem(this.tableElasticIPs, 0);
            tableItem.setData((Object)addressInfo);
            tableItem.setText(fields);
        }
    }

    public String getSelectedElasticIP() {
        TableItem[] selection = this.tableElasticIPs.getSelection();
        if (selection.length > 0) {
            AddressInfo addressInfo = (AddressInfo)selection[0].getData();
            return addressInfo.getPublicIp();
        }
        return null;
    }
}

