/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.ui.actions;

import eu.geclipse.aws.s3.S3BucketStorage;
import eu.geclipse.aws.s3.internal.S3ServiceRegistry;
import eu.geclipse.aws.s3.ui.actions.AbstractAWSProjectAction;
import eu.geclipse.aws.s3.ui.actions.Messages;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;

public class DeleteBucketAction
extends AbstractAWSProjectAction {
    private List<S3BucketStorage> bucketList = new ArrayList<S3BucketStorage>();

    public void run(IAction action) {
        if (action.isEnabled()) {
            Job job = new Job(Messages.getString(Messages.getString("DeleteBucketAction.jobDeleteBucket_title"))){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask(Messages.getString("DeleteBucketAction.taskTitleDeleteBucket_text"), -1);
                            S3ServiceRegistry s3ServiceRegistry = S3ServiceRegistry.getRegistry();
                            S3Service service = s3ServiceRegistry.getService(DeleteBucketAction.this.getAwsVo().getProperties().getAwsAccessId());
                            IVirtualOrganization projectVo = null;
                            if (service != null) {
                                for (S3BucketStorage bucket : DeleteBucketAction.this.bucketList) {
                                    service.deleteBucket(bucket.getS3Bucket());
                                    projectVo = (IVirtualOrganization)bucket.getParent();
                                }
                            }
                            if (projectVo != null) {
                                projectVo.refreshResources(GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.storage.s3"), monitor);
                            }
                        }
                        catch (Exception ex) {
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                    String message = null;
                                    Exception exToDisplay = null;
                                    if (ex instanceof S3ServiceException) {
                                        S3ServiceException s3ServiceEx = (S3ServiceException)ex;
                                        message = s3ServiceEx.getS3ErrorMessage();
                                    } else {
                                        Messages.getString("DeleteBucketAction.errorCreateBucket_description");
                                        exToDisplay = ex;
                                    }
                                    ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("DeleteBucketAction.errorCreateBucket_title"), (String)message, (Throwable)exToDisplay);
                                }
                            });
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.setUser(true);
            job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.extractAWSVoFromCategory(selection);
        boolean enable = false;
        this.bucketList.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection.toList()) {
                if (!(element instanceof S3BucketStorage)) continue;
                S3BucketStorage bucket = (S3BucketStorage)element;
                this.bucketList.add(bucket);
            }
        }
        if (this.bucketList.size() > 0) {
            enable = true;
        }
        action.setEnabled(enable);
    }
}

