/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.ui.properties;

import eu.geclipse.aws.s3.S3BucketStorage;
import eu.geclipse.aws.s3.ui.properties.Messages;
import eu.geclipse.aws.s3.ui.properties.SimpleProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3BucketStoragePropertySource
extends AbstractPropertySource<Object> {
    private List<IProperty<Object>> propertiesList;
    private S3BucketStorage s3BucketStorage;

    public S3BucketStoragePropertySource(S3BucketStorage sourceObject) {
        super((Object)sourceObject);
        this.s3BucketStorage = sourceObject;
    }

    private List<IProperty<Object>> getProperties() {
        ArrayList<IProperty<Object>> propertyList = new ArrayList<IProperty<Object>>();
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("S3BucketStoragePropertySource.property_name"), this.s3BucketStorage.getName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("S3BucketStoragePropertySource.property_host_name"), this.s3BucketStorage.getHostName()));
        propertyList.add((IProperty<Object>)new SimpleProperty(Messages.getString("S3BucketStoragePropertySource.property_uri"), this.s3BucketStorage.getURI().toString()));
        return propertyList;
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return ((Object)((Object)this)).getClass();
    }

    protected List<IProperty<Object>> getStaticProperties() {
        if (this.propertiesList == null) {
            this.propertiesList = this.getProperties();
        }
        return this.propertiesList;
    }
}

