/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.ui.wizards;

import eu.geclipse.aws.s3.S3ProblemException;
import eu.geclipse.aws.s3.internal.S3ServiceRegistry;
import eu.geclipse.aws.s3.ui.internal.Activator;
import eu.geclipse.aws.s3.ui.wizards.CreateBucketWizardPage;
import eu.geclipse.aws.s3.ui.wizards.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;

public class CreateBucketWizard
extends Wizard {
    private AWSVirtualOrganization awsVo;
    private CreateBucketWizardPage wizardPage;

    public CreateBucketWizard(AWSVirtualOrganization awsVo) {
        this.awsVo = awsVo;
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void addPages() {
        this.wizardPage = new CreateBucketWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public String getWindowTitle() {
        return Messages.getString("CreateBucketWizard.window_title");
    }

    public boolean performFinish() {
        if (this.wizardPage.isPageComplete()) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                String bucketName = CreateBucketWizard.this.wizardPage.getBucketName();
                                String location = CreateBucketWizard.this.wizardPage.getLocation();
                                monitor.beginTask(Messages.getString("CreateBucketWizard.taskCreateBucket_title"), -1);
                                S3ServiceRegistry s3ServiceRegistry = S3ServiceRegistry.getRegistry();
                                S3Service service = s3ServiceRegistry.getService(CreateBucketWizard.this.awsVo.getProperties().getAwsAccessId());
                                if (service != null) {
                                    service.createBucket(bucketName, location);
                                }
                            }
                            catch (Exception ex) {
                                throw new InvocationTargetException(ex, "Could not create bucket");
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.showErrorDialog(ex);
            }
            return true;
        }
        return false;
    }

    private void showErrorDialog(Exception ex) {
        Activator.log("A problem occured while creating a s3 bucket", ex);
        S3ProblemException exception = new S3ProblemException("eu.geclipse.aws.s3.problem.bucketCreateFailed", ex.getCause().getLocalizedMessage(), (Throwable)ex, "eu.geclipse.aws.s3.ui");
        String message = null;
        S3ProblemException displayException = null;
        if (ex.getCause() instanceof S3ServiceException) {
            S3ServiceException s3ServiceEx = (S3ServiceException)ex.getCause();
            message = s3ServiceEx.getS3ErrorMessage();
        } else {
            message = MessageFormat.format(Messages.getString("CreateBucketWizard.errorCreatingBucket_message"), this.wizardPage.getBucketName());
            displayException = exception;
        }
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ProblemDialog.openProblem((Shell)workbenchWindow.getShell(), (String)Messages.getString("CreateBucketWizard.errorCreatingBucket_title"), (String)message, (Throwable)displayException);
    }
}

