/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3;

import eu.geclipse.aws.s3.internal.Activator;
import eu.geclipse.aws.s3.internal.Messages;
import eu.geclipse.aws.s3.service.S3AWSService;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IMountable;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.jets3t.service.model.S3Bucket;

public class S3BucketStorage
extends AbstractGridElement
implements IGridResource,
IMountable {
    public static final IMountable.MountPointID MOUNT_ID = new IMountable.MountPointID(Messages.getString("S3BucketStorage.mount_action_title"), "s3");
    private S3AWSService s3AWSService;
    private S3Bucket s3Bucket;
    private IGridContainer parent;

    public S3Bucket getS3Bucket() {
        return this.s3Bucket;
    }

    public S3BucketStorage(IGridContainer parent, S3AWSService s3AWSService, S3Bucket bucket) {
        this.parent = parent;
        this.s3AWSService = s3AWSService;
        this.s3Bucket = bucket;
    }

    private URI getMountURI() {
        StringBuilder sb = new StringBuilder("s3");
        sb.append("://");
        AWSVirtualOrganization awsVo = (AWSVirtualOrganization)this.s3AWSService.getParent();
        String awsAccessId = null;
        try {
            awsAccessId = awsVo.getProperties().getAwsAccessId();
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain aws properties", (Exception)((Object)problemEx));
        }
        if (awsAccessId != null) {
            sb.append(awsAccessId);
        }
        sb.append("/");
        sb.append(this.getName());
        URI accessToken = null;
        try {
            accessToken = new URI(sb.toString());
        }
        catch (URISyntaxException exc) {
            Activator.log(exc);
        }
        return accessToken;
    }

    public String getName() {
        return this.s3Bucket.getName();
    }

    public String getHostName() {
        try {
            String s3Url = this.s3AWSService.getProperties().getS3Url();
            URL url = new URL(s3Url);
            return url.getHost();
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain properties from s3AWSService", (Exception)((Object)problemEx));
        }
        catch (MalformedURLException malformedURLEx) {
            Activator.log("Could not convert URL from s3AWSService", malformedURLEx);
        }
        return null;
    }

    public URI getURI() {
        String s3Url = null;
        try {
            s3Url = this.s3AWSService.getProperties().getS3Url();
            StringBuilder strBuilder = new StringBuilder(s3Url);
            if (!s3Url.endsWith("/")) {
                strBuilder.append('/');
            }
            s3Url = String.valueOf(s3Url) + this.s3Bucket.getName();
            return new URI(s3Url);
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not obtain properties from awsVo", (Exception)((Object)problemEx));
        }
        catch (URISyntaxException uriSyntaxEx) {
            Activator.log("Could not construct URI from awsVo: " + s3Url, uriSyntaxEx);
        }
        return null;
    }

    public IFileStore getFileStore() {
        return null;
    }

    public IGridContainer getParent() {
        return this.parent;
    }

    public IPath getPath() {
        return null;
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    public IMountable.MountPoint getMountPoint(IMountable.MountPointID mountID) {
        URI uri;
        IMountable.MountPoint result = null;
        if (MOUNT_ID.equals((Object)mountID) && (uri = this.getMountURI()) != null) {
            result = new IMountable.MountPoint(this.s3Bucket.getName(), uri);
        }
        return result;
    }

    public IMountable.MountPointID[] getMountPointIDs() {
        return new IMountable.MountPointID[]{MOUNT_ID};
    }
}

