/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.internal;

import eu.geclipse.aws.auth.AWSAuthToken;
import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.s3.internal.Messages;
import eu.geclipse.core.auth.AbstractAuthTokenProvider;
import eu.geclipse.core.auth.AuthTokenRequest;
import eu.geclipse.core.auth.AuthenticationTokenManager;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.security.ISecurityManager;
import eu.geclipse.core.security.ISecurityManagerListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;

public class S3ServiceRegistry
implements ISecurityManagerListener {
    private Hashtable<String, S3Service> services = new Hashtable();

    public static S3ServiceRegistry getRegistry() {
        return SingletonHolder.instance;
    }

    private S3ServiceRegistry() {
        AuthenticationTokenManager.getManager().addListener((ISecurityManagerListener)this);
    }

    public void clear() {
        this.services.clear();
    }

    public S3Service getService(String awsAccessId) throws ProblemException {
        AWSAuthTokenDescription awsAuthTokenDesc = new AWSAuthTokenDescription(awsAccessId);
        AuthTokenRequest request = new AuthTokenRequest((IAuthenticationTokenDescription)awsAuthTokenDesc, Messages.getString("S3ServiceRegistry.auth_requester"), Messages.getString("S3ServiceRegistry.auth_request"));
        AWSAuthToken awsAuthToken = (AWSAuthToken)AbstractAuthTokenProvider.staticRequestToken((AuthTokenRequest)request);
        if (awsAuthToken != null) {
            S3Service existingService = this.services.get(awsAuthToken);
            if (existingService == null) {
                awsAuthTokenDesc = (AWSAuthTokenDescription)awsAuthToken.getDescription();
                AWSCredentials awsCredentials = new AWSCredentials(awsAuthTokenDesc.getAwsAccessId(), awsAuthTokenDesc.getAwsSecretId());
                RestS3Service service = null;
                try {
                    service = new RestS3Service(awsCredentials, "g-Eclipse/1.0", null);
                }
                catch (S3ServiceException s3ServiceException) {
                    throw new ProblemException("eu.geclipse.aws.s3.problem.service.rest.creationFailed", "eu.geclipse.aws.s3");
                }
                AWSAuthTokenDescription activeAuthDesc = (AWSAuthTokenDescription)awsAuthToken.getDescription();
                this.services.put(activeAuthDesc.getAwsAccessId(), (S3Service)service);
                return service;
            }
            return existingService;
        }
        return null;
    }

    public void contentChanged(ISecurityManager manager) {
        if (manager instanceof AuthenticationTokenManager) {
            AuthenticationTokenManager authTokenManager = (AuthenticationTokenManager)manager;
            List tokens = authTokenManager.getTokens();
            Set<Map.Entry<String, S3Service>> entrySet = this.services.entrySet();
            ArrayList<String> elementsToRemove = new ArrayList<String>(this.services.size());
            for (Map.Entry<String, S3Service> entry : entrySet) {
                boolean found = false;
                for (IAuthenticationToken authToken : tokens) {
                    if (!(authToken instanceof AWSAuthTokenDescription)) continue;
                    AWSAuthTokenDescription awsAuthTokenDesc = (AWSAuthTokenDescription)authToken.getDescription();
                    if (entry.getKey() != awsAuthTokenDesc.getAwsAccessId()) continue;
                    found = true;
                }
                if (found) continue;
                elementsToRemove.add(entry.getKey());
            }
            for (String awsAccessId : elementsToRemove) {
                this.services.remove(awsAccessId);
            }
        }
    }

    /* synthetic */ S3ServiceRegistry(S3ServiceRegistry s3ServiceRegistry) {
        this();
    }

    private static class SingletonHolder {
        private static final S3ServiceRegistry instance = new S3ServiceRegistry(null);

        private SingletonHolder() {
        }
    }
}

