/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.s3.service;

import eu.geclipse.aws.IAWSService;
import eu.geclipse.aws.s3.internal.Activator;
import eu.geclipse.aws.s3.service.S3AWSServiceCreator;
import eu.geclipse.aws.s3.service.S3InfoService;
import eu.geclipse.aws.s3.service.S3ServiceProperties;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class S3AWSService
extends AbstractGridContainer
implements IAWSService,
IStorableElement {
    public static final String STORAGE_NAME = "eu.geclipse.aws.s3.service.s3AWSServiceCreator";
    public static IGridResourceCategory[] categories = new IGridResourceCategory[]{GridResourceCategoryFactory.getCategory((String)"eu.geclipse.aws.storage.s3")};
    private AWSVirtualOrganization awsVo;

    public S3AWSService(S3AWSServiceCreator serviceCreator, AWSVirtualOrganization vo) {
        this.awsVo = vo;
        try {
            this.apply(serviceCreator);
            this.addElement((IGridElement)new S3InfoService(this));
        }
        catch (ProblemException e) {
            Activator.log("Could not populate S3AWSAService with data from provided S3 service creator", (Exception)((Object)e));
        }
    }

    public S3AWSService(AWSVirtualOrganization vo) {
        this.awsVo = vo;
        try {
            S3ServiceProperties serviceProperties = new S3ServiceProperties(this);
            serviceProperties.load();
            this.addElement((IGridElement)serviceProperties);
            this.addElement((IGridElement)new S3InfoService(this));
        }
        catch (ProblemException e) {
            Activator.log("Could not load the s3 service details from the filestore", (Exception)((Object)e));
        }
    }

    public boolean canContain(IGridElement element) {
        return element instanceof S3ServiceProperties || element instanceof S3InfoService;
    }

    public void apply(S3AWSServiceCreator serviceCreator) throws ProblemException {
        S3ServiceProperties properties = new S3ServiceProperties(this, serviceCreator);
        this.addElement((IGridElement)properties);
    }

    public IGridResourceCategory[] getSupportedResources() {
        return categories;
    }

    public String getHostName() {
        S3ServiceProperties properties = null;
        try {
            properties = this.getProperties();
        }
        catch (ProblemException e) {
            Activator.log("Could not load the properties of the s3 service", (Exception)((Object)e));
        }
        if (properties != null) {
            return properties.getS3Url();
        }
        return null;
    }

    public URI getURI() {
        String hostName = this.getHostName();
        try {
            if (hostName != null) {
                return new URI(hostName);
            }
        }
        catch (URISyntaxException e) {
            Activator.log("Could not create S3 service URI from " + hostName, e);
        }
        return null;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(STORAGE_NAME);
    }

    public String getName() {
        S3ServiceProperties properties = null;
        try {
            properties = this.getProperties();
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not load the properties of the s3 service", (Exception)((Object)problemEx));
        }
        if (properties != null) {
            return properties.getServiceName();
        }
        return null;
    }

    public IGridContainer getParent() {
        return this.awsVo;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(STORAGE_NAME);
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof S3AWSService) {
            result = this.equals((S3AWSService)((Object)obj));
        }
        return result;
    }

    private boolean equals(S3AWSService service) {
        return this.getName().equals(service.getName());
    }

    public S3ServiceProperties getProperties() throws ProblemException {
        IGridElement[] children;
        S3ServiceProperties properties = null;
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof S3ServiceProperties) {
                properties = (S3ServiceProperties)child;
                break;
            }
            ++n2;
        }
        return properties;
    }

    public IGridInfoService getInfoService() {
        S3InfoService infoService = null;
        try {
            IGridElement[] children;
            IGridElement[] iGridElementArray = children = this.getChildren(null);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement child = iGridElementArray[n2];
                if (child instanceof IGridInfoService) {
                    infoService = (S3InfoService)child;
                    break;
                }
                ++n2;
            }
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not get info service from EC2Service", (Exception)((Object)problemEx));
        }
        return infoService;
    }

    public void load() throws ProblemException {
        this.deleteAll();
        this.addElement((IGridElement)new S3InfoService(this));
        IFileStore fileStore = this.getFileStore();
        try {
            IFileStore[] childStores;
            IFileStore[] iFileStoreArray = childStores = fileStore.childStores(0, null);
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                if (child.getName().equals(".s3_service_properties")) {
                    S3ServiceProperties serviceProperties = new S3ServiceProperties(this);
                    serviceProperties.load();
                    this.addElement((IGridElement)serviceProperties);
                }
                ++n2;
            }
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.aws.s3");
        }
    }

    public void save() throws ProblemException {
        IGridElement[] children;
        IFileStore fileStore = this.getFileStore();
        if (!fileStore.fetchInfo().exists()) {
            try {
                fileStore.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.log("Could not create storage dir for s3Service", (Exception)((Object)e));
                return;
            }
        }
        IGridElement[] iGridElementArray = children = this.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IGridElement child = iGridElementArray[n2];
            if (child instanceof IStorableElement) {
                ((IStorableElement)child).save();
            }
            ++n2;
        }
    }
}

